/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerWard;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncWardPacket;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;

public class PlayerWard
implements IPlayerWard {
    protected static final List<EquipmentSlot> APPLICABLE_SLOTS = List.of(EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.HEAD, EquipmentSlot.FEET);
    protected static final int PAUSE_DURATION_MILLIS = 10000;
    private float current = 0.0f;
    private float max = 0.0f;
    private long lastPaused = 0L;
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        rootTag.putFloat("Current", this.current);
        rootTag.putFloat("Max", this.max);
        rootTag.putLong("LastPaused", this.lastPaused);
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clear();
        this.current = nbt.getFloat("Current");
        this.max = nbt.getFloat("Max");
        this.lastPaused = nbt.getLong("LastPaused");
    }

    @Override
    public List<EquipmentSlot> getApplicableSlots() {
        return APPLICABLE_SLOTS;
    }

    @Override
    public float getCurrentWard() {
        return this.current;
    }

    @Override
    public float getMaxWard() {
        return this.max;
    }

    @Override
    public void setCurrentWard(float ward) {
        this.current = Mth.clamp((float)ward, (float)0.0f, (float)this.getMaxWard());
    }

    @Override
    public void setMaxWard(float ward) {
        this.max = ward;
        this.current = Mth.clamp((float)this.current, (float)0.0f, (float)this.getMaxWard());
    }

    @Override
    public boolean isRegenerating() {
        return this.getCurrentWard() < this.getMaxWard() && System.currentTimeMillis() >= this.lastPaused + 10000L;
    }

    @Override
    public void pauseRegeneration() {
        this.lastPaused = System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.current = 0.0f;
        this.max = 0.0f;
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncWardPacket((Player)player), player);
        }
    }
}

