/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerStats;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncStatsPacket;
import com.verdantartifice.primalmagick.common.stats.Stat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerStats
implements IPlayerStats {
    private final Map<ResourceLocation, Integer> stats = new ConcurrentHashMap<ResourceLocation, Integer>();
    private final Set<Long> discoveredShrines = ConcurrentHashMap.newKeySet();
    private final Set<ResourceLocation> craftedRecipes = ConcurrentHashMap.newKeySet();
    private final Set<ResourceLocation> craftedGroups = ConcurrentHashMap.newKeySet();
    private final Set<ResourceLocation> craftedEnchs = ConcurrentHashMap.newKeySet();
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag statList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.stats.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.putString("Key", entry.getKey().toString());
            tag.putInt("Value", entry.getValue().intValue());
            statList.add((Object)tag);
        }
        rootTag.put("Stats", (Tag)statList);
        long[] locs = new long[this.discoveredShrines.size()];
        int index = 0;
        for (Long l : this.discoveredShrines) {
            locs[index++] = l;
        }
        rootTag.put("ShrineLocations", (Tag)new LongArrayTag(locs));
        ListTag recipeList = new ListTag();
        for (ResourceLocation resourceLocation : this.craftedRecipes) {
            recipeList.add((Object)StringTag.valueOf((String)resourceLocation.toString()));
        }
        rootTag.put("CraftedRecipes", (Tag)recipeList);
        ListTag listTag = new ListTag();
        for (ResourceLocation groupId : this.craftedGroups) {
            listTag.add((Object)StringTag.valueOf((String)groupId.toString()));
        }
        rootTag.put("CraftedGroups", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (ResourceLocation enchId : this.craftedEnchs) {
            listTag2.add((Object)StringTag.valueOf((String)enchId.toString()));
        }
        rootTag.put("CraftedRuneEnchantments", (Tag)listTag2);
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        long[] locs;
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clear();
        ListTag statList = nbt.getList("Stats", 10);
        for (int index = 0; index < statList.size(); ++index) {
            CompoundTag compoundTag = statList.getCompound(index);
            ResourceLocation loc = ResourceLocation.parse((String)compoundTag.getString("Key"));
            Integer value = compoundTag.getInt("Value");
            this.stats.put(loc, value);
        }
        for (long loc : locs = nbt.getLongArray("ShrineLocations")) {
            this.discoveredShrines.add(loc);
        }
        ListTag listTag = nbt.getList("CraftedRecipes", 8);
        for (int index = 0; index < listTag.size(); ++index) {
            String idStr = listTag.getString(index);
            this.craftedRecipes.add(ResourceLocation.parse((String)idStr));
        }
        ListTag groupList = nbt.getList("CraftedGroups", 8);
        for (int index = 0; index < groupList.size(); ++index) {
            String idStr = groupList.getString(index);
            this.craftedGroups.add(ResourceLocation.parse((String)idStr));
        }
        ListTag enchList = nbt.getList("CraftedRuneEnchantments", 8);
        for (int index = 0; index < enchList.size(); ++index) {
            String idStr = enchList.getString(index);
            this.craftedEnchs.add(ResourceLocation.parse((String)idStr));
        }
    }

    @Override
    public void clear() {
        this.stats.clear();
        this.discoveredShrines.clear();
        this.craftedRecipes.clear();
        this.craftedGroups.clear();
        this.craftedEnchs.clear();
    }

    @Override
    public int getValue(Stat stat) {
        if (stat == null) {
            return 0;
        }
        return this.stats.getOrDefault(stat.key(), 0);
    }

    @Override
    public void setValue(Stat stat, int value) {
        if (stat != null) {
            this.stats.put(stat.key(), value);
        }
    }

    @Override
    public boolean isLocationDiscovered(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        return this.discoveredShrines.contains(pos.asLong());
    }

    @Override
    public void setLocationDiscovered(BlockPos pos) {
        if (pos != null) {
            this.discoveredShrines.add(pos.asLong());
        }
    }

    @Override
    public boolean isRecipeCrafted(ResourceLocation recipeId) {
        return this.craftedRecipes.contains(recipeId);
    }

    @Override
    public boolean isRecipeGroupCrafted(ResourceLocation groupId) {
        return this.craftedGroups.contains(groupId);
    }

    @Override
    public boolean isRuneEnchantmentCrafted(ResourceLocation enchantmentId) {
        return this.craftedEnchs.contains(enchantmentId);
    }

    @Override
    public void setRecipeCrafted(ResourceLocation recipeId) {
        this.craftedRecipes.add(recipeId);
    }

    @Override
    public void setRecipeGroupCrafted(ResourceLocation groupId) {
        this.craftedGroups.add(groupId);
    }

    @Override
    public void setRuneEnchantmentCrafted(ResourceLocation enchantmentId) {
        this.craftedEnchs.add(enchantmentId);
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncStatsPacket((Player)player), player);
        }
    }
}

