/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.verdantartifice.primalmagick.common.books.ScribeTableMode;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncLinguisticsPacket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector2i;

public class PlayerLinguistics
implements IPlayerLinguistics {
    private final Map<ResourceLocation, Integer> comprehension = new ConcurrentHashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, Integer> vocabulary = new ConcurrentHashMap<ResourceLocation, Integer>();
    private final Map<ResourceLocation, Set<ResourceLocation>> booksRead = new ConcurrentHashMap<ResourceLocation, Set<ResourceLocation>>();
    private final Table<ResourceLocation, ResourceLocation, Integer> studyCounts = HashBasedTable.create();
    private final Map<ResourceLocation, Set<Vector2i>> unlocks = new ConcurrentHashMap<ResourceLocation, Set<Vector2i>>();
    private final Map<ResourceLocation, Long> gridModificationTimes = new ConcurrentHashMap<ResourceLocation, Long>();
    private ScribeTableMode scribeTableMode = ScribeTableMode.STUDY_VOCABULARY;
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag comprehensionList = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.comprehension.entrySet()) {
            if (entry == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("Language", entry.getKey().toString());
            compoundTag.putInt("Value", ((Integer)entry.getValue()).intValue());
            comprehensionList.add((Object)compoundTag);
        }
        rootTag.put("Comprehension", (Tag)comprehensionList);
        ListTag vocabularyList = new ListTag();
        for (Map.Entry entry : this.vocabulary.entrySet()) {
            if (entry == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("Language", ((ResourceLocation)entry.getKey()).toString());
            compoundTag.putInt("Value", ((Integer)entry.getValue()).intValue());
            vocabularyList.add((Object)compoundTag);
        }
        rootTag.put("Vocabulary", (Tag)vocabularyList);
        ListTag booksReadLanguageList = new ListTag();
        for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : this.booksRead.entrySet()) {
            if (entry == null) continue;
            CompoundTag langTag = new CompoundTag();
            langTag.putString("Language", entry.getKey().toString());
            ListTag listTag = new ListTag();
            for (ResourceLocation bookId : entry.getValue()) {
                if (bookId == null) continue;
                listTag.add((Object)StringTag.valueOf((String)bookId.toString()));
            }
            langTag.put("Books", (Tag)listTag);
            booksReadLanguageList.add((Object)langTag);
        }
        rootTag.put("BooksRead", (Tag)booksReadLanguageList);
        ListTag listTag = new ListTag();
        for (Object cell : this.studyCounts.cellSet()) {
            if (cell == null) continue;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putString("Book", ((ResourceLocation)cell.getRowKey()).toString());
            compoundTag.putString("Language", ((ResourceLocation)cell.getColumnKey()).toString());
            compoundTag.putInt("Value", ((Integer)cell.getValue()).intValue());
            listTag.add((Object)compoundTag);
        }
        rootTag.put("StudyCounts", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry entry : this.unlocks.entrySet()) {
            if (entry == null) continue;
            CompoundTag gridTag = new CompoundTag();
            gridTag.putString("GridDef", ((ResourceLocation)entry.getKey()).toString());
            ListTag unlockCoordsList = new ListTag();
            for (Vector2i coords : (Set)entry.getValue()) {
                if (coords == null) continue;
                CompoundTag coordsTag = new CompoundTag();
                coordsTag.putInt("X", coords.x());
                coordsTag.putInt("Y", coords.y());
                unlockCoordsList.add((Object)coordsTag);
            }
            gridTag.put("Coords", (Tag)unlockCoordsList);
            listTag2.add((Object)gridTag);
        }
        rootTag.put("Unlocks", (Tag)listTag2);
        ListTag modifiedList = new ListTag();
        for (Map.Entry<ResourceLocation, Long> entry : this.gridModificationTimes.entrySet()) {
            if (entry == null) continue;
            CompoundTag tag = new CompoundTag();
            tag.putString("GridDef", entry.getKey().toString());
            tag.putLong("LastModified", entry.getValue().longValue());
            modifiedList.add((Object)tag);
        }
        rootTag.put("GridModifiedTimes", (Tag)modifiedList);
        rootTag.putString("ScribeTableMode", this.scribeTableMode.getSerializedName());
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clear();
        ListTag comprehensionList = nbt.getList("Comprehension", 10);
        for (int index = 0; index < comprehensionList.size(); ++index) {
            CompoundTag tag = comprehensionList.getCompound(index);
            this.setComprehension(ResourceLocation.parse((String)tag.getString("Language")), tag.getInt("Value"));
        }
        ListTag vocabularyList = nbt.getList("Vocabulary", 10);
        for (int index = 0; index < vocabularyList.size(); ++index) {
            CompoundTag tag = vocabularyList.getCompound(index);
            this.setVocabulary(ResourceLocation.parse((String)tag.getString("Language")), tag.getInt("Value"));
        }
        ListTag booksReadList = nbt.getList("BooksRead", 10);
        for (int langIndex = 0; langIndex < booksReadList.size(); ++langIndex) {
            CompoundTag langTag = booksReadList.getCompound(langIndex);
            ResourceLocation langId = ResourceLocation.parse((String)langTag.getString("Language"));
            ListTag booksList = langTag.getList("Books", 8);
            for (int bookIndex = 0; bookIndex < booksList.size(); ++bookIndex) {
                ResourceLocation bookId = ResourceLocation.parse((String)booksList.getString(bookIndex));
                this.markRead(bookId, langId);
            }
        }
        ListTag studyCountList = nbt.getList("StudyCounts", 10);
        for (int index = 0; index < studyCountList.size(); ++index) {
            CompoundTag tag = studyCountList.getCompound(index);
            this.setTimesStudied(ResourceLocation.parse((String)tag.getString("Book")), ResourceLocation.parse((String)tag.getString("Language")), tag.getInt("Value"));
        }
        ListTag unlockGridList = nbt.getList("Unlocks", 10);
        for (int gridIndex = 0; gridIndex < unlockGridList.size(); ++gridIndex) {
            CompoundTag gridTag = unlockGridList.getCompound(gridIndex);
            ResourceLocation gridId = ResourceLocation.parse((String)gridTag.getString("GridDef"));
            ListTag coordsList = gridTag.getList("Coords", 10);
            for (int coordsIndex = 0; coordsIndex < coordsList.size(); ++coordsIndex) {
                CompoundTag coordsTag = coordsList.getCompound(coordsIndex);
                this.unlockNode(gridId, new Vector2i(coordsTag.getInt("X"), coordsTag.getInt("Y")));
            }
        }
        ListTag modifiedList = nbt.getList("GridModifiedTimes", 10);
        for (int index = 0; index < modifiedList.size(); ++index) {
            CompoundTag tag = modifiedList.getCompound(index);
            this.setLastModified(ResourceLocation.parse((String)tag.getString("GridDef")), tag.getLong("LastModified"));
        }
        ScribeTableMode mode = ScribeTableMode.fromName(nbt.getString("ScribeTableMode"));
        this.scribeTableMode = mode == null ? ScribeTableMode.STUDY_VOCABULARY : mode;
    }

    @Override
    public void clear() {
        this.comprehension.clear();
        this.vocabulary.clear();
        this.booksRead.clear();
        this.studyCounts.clear();
        this.unlocks.clear();
        this.scribeTableMode = ScribeTableMode.STUDY_VOCABULARY;
        this.gridModificationTimes.clear();
    }

    @Override
    public boolean isLanguageKnown(ResourceLocation languageId) {
        return this.booksRead.getOrDefault(languageId, Collections.emptySet()).size() > 0 || this.getVocabulary(languageId) > 0 || this.getComprehension(languageId) > 0;
    }

    @Override
    public boolean markRead(ResourceLocation bookDefinitionId, ResourceLocation languageId) {
        return this.booksRead.computeIfAbsent(languageId, key -> new HashSet()).add(bookDefinitionId);
    }

    @Override
    public int getComprehension(ResourceLocation languageId) {
        return this.comprehension.getOrDefault(languageId, 0);
    }

    @Override
    public void setComprehension(ResourceLocation languageId, int value) {
        this.comprehension.put(languageId, value);
    }

    @Override
    public int getVocabulary(ResourceLocation languageId) {
        return this.vocabulary.getOrDefault(languageId, 0);
    }

    @Override
    public void setVocabulary(ResourceLocation languageId, int value) {
        this.vocabulary.put(languageId, value);
    }

    @Override
    public int getTimesStudied(ResourceLocation bookDefinitionId, ResourceLocation languageId) {
        return this.studyCounts.contains((Object)bookDefinitionId, (Object)languageId) ? (Integer)this.studyCounts.get((Object)bookDefinitionId, (Object)languageId) : 0;
    }

    @Override
    public void setTimesStudied(ResourceLocation bookDefinitionId, ResourceLocation languageId, int value) {
        this.studyCounts.put((Object)bookDefinitionId, (Object)languageId, (Object)Mth.clamp((int)value, (int)0, (int)3));
    }

    @Override
    public ScribeTableMode getScribeTableMode() {
        return this.scribeTableMode;
    }

    @Override
    public void setScribeTableMode(ScribeTableMode mode) {
        this.scribeTableMode = (ScribeTableMode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
    }

    @Override
    public Set<Vector2i> getUnlockedNodes(ResourceLocation gridDefinitionId) {
        return Collections.unmodifiableSet(this.unlocks.getOrDefault(gridDefinitionId, Collections.emptySet()));
    }

    @Override
    public void clearUnlockedNodes(ResourceLocation gridDefinitionId) {
        this.setLastModified(gridDefinitionId, System.currentTimeMillis());
        this.unlocks.remove(gridDefinitionId);
    }

    @Override
    public boolean unlockNode(ResourceLocation gridDefinitionId, Vector2i nodePos) {
        this.setLastModified(gridDefinitionId, System.currentTimeMillis());
        return this.unlocks.computeIfAbsent(gridDefinitionId, k -> new HashSet()).add(nodePos);
    }

    @Override
    public long getGridLastModified(ResourceLocation gridDefinitionId) {
        return this.gridModificationTimes.getOrDefault(gridDefinitionId, 0L);
    }

    private void setLastModified(ResourceLocation gridDefinitionId, long lastModified) {
        this.gridModificationTimes.put(gridDefinitionId, lastModified);
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncLinguisticsPacket((Player)player), player);
        }
    }
}

