/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerKnowledge;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncKnowledgePacket;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.ResearchEntries;
import com.verdantartifice.primalmagick.common.research.ResearchEntry;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.keys.ResearchEntryKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.research.topics.MainIndexResearchTopic;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class PlayerKnowledge
implements IPlayerKnowledge {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int LEGACY_VERSION = 0;
    public static final int UNREAD_FLAG_VERSION = 1;
    public static final int CURRENT_SCHEMA_VERSION = 1;
    public static final Codec<PlayerKnowledge> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractResearchKey.dispatchCodec().listOf().xmap(ImmutableSet::copyOf, ImmutableList::copyOf).fieldOf("research").forGetter(k -> k.research), (App)StageEntry.CODEC.listOf().xmap(entryList -> (Map)entryList.stream().collect(ImmutableMap.toImmutableMap(StageEntry::key, StageEntry::stage)), entryMap -> entryMap.entrySet().stream().map(e -> new StageEntry((AbstractResearchKey)e.getKey(), (Integer)e.getValue())).toList()).fieldOf("stages").forGetter(k -> k.stages), (App)FlagsEntry.CODEC.listOf().xmap(entryList -> (Map)entryList.stream().collect(ImmutableMap.toImmutableMap(FlagsEntry::key, FlagsEntry::flagSet)), entryMap -> entryMap.entrySet().stream().map(e -> new FlagsEntry((AbstractResearchKey)e.getKey(), (Set)e.getValue())).toList()).fieldOf("flags").forGetter(k -> k.flags), (App)Codec.simpleMap(KnowledgeType.CODEC, (Codec)Codec.INT, (Keyable)StringRepresentable.keys((StringRepresentable[])KnowledgeType.values())).fieldOf("knowledge").forGetter(k -> k.knowledge), (App)AbstractResearchTopic.dispatchCodec().listOf().fieldOf("topicHistory").forGetter(k -> k.topicHistory), (App)Project.codec().optionalFieldOf("project").forGetter(k -> k.project), (App)AbstractResearchTopic.dispatchCodec().optionalFieldOf("topic").forGetter(k -> k.topic), (App)Codec.INT.optionalFieldOf("schemaVersion", (Object)0).forGetter(k -> k.schemaVersion), (App)Codec.LONG.optionalFieldOf("syncTimestamp", (Object)0L).forGetter(k -> k.syncTimestamp)).apply((Applicative)instance, PlayerKnowledge::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlayerKnowledge> STREAM_CODEC = StreamCodecUtils.composite(AbstractResearchKey.dispatchStreamCodec().apply(ByteBufCodecs.list()).map(ImmutableSet::copyOf, ImmutableList::copyOf), k -> k.research, StageEntry.STREAM_CODEC.apply(ByteBufCodecs.list()).map(entryList -> (Map)entryList.stream().collect(ImmutableMap.toImmutableMap(StageEntry::key, StageEntry::stage)), entryMap -> entryMap.entrySet().stream().map(e -> new StageEntry((AbstractResearchKey)e.getKey(), (Integer)e.getValue())).toList()), k -> k.stages, FlagsEntry.STREAM_CODEC.apply(ByteBufCodecs.list()).map(entryList -> (Map)entryList.stream().collect(ImmutableMap.toImmutableMap(FlagsEntry::key, FlagsEntry::flagSet)), entryMap -> entryMap.entrySet().stream().map(e -> new FlagsEntry((AbstractResearchKey)e.getKey(), (Set)e.getValue())).toList()), k -> k.flags, ByteBufCodecs.map(Object2IntOpenHashMap::new, KnowledgeType.STREAM_CODEC, (StreamCodec)ByteBufCodecs.VAR_INT), k -> k.knowledge, AbstractResearchTopic.dispatchStreamCodec().apply(ByteBufCodecs.list()), k -> k.topicHistory, ByteBufCodecs.optional(Project.streamCodec()), k -> k.project, ByteBufCodecs.optional(AbstractResearchTopic.dispatchStreamCodec()), k -> k.topic, ByteBufCodecs.VAR_INT, k -> k.schemaVersion, ByteBufCodecs.VAR_LONG, k -> k.syncTimestamp, PlayerKnowledge::new);
    private final Set<AbstractResearchKey<?>> research = ConcurrentHashMap.newKeySet();
    private final Map<AbstractResearchKey<?>, Integer> stages = new ConcurrentHashMap();
    private final Map<AbstractResearchKey<?>, Set<IPlayerKnowledge.ResearchFlag>> flags = new ConcurrentHashMap();
    private final Map<KnowledgeType, Integer> knowledge = new ConcurrentHashMap<KnowledgeType, Integer>();
    private final LinkedList<AbstractResearchTopic<?>> topicHistory = new LinkedList();
    private Optional<Project> project;
    private Optional<AbstractResearchTopic<?>> topic;
    private int schemaVersion;
    private long syncTimestamp;

    public PlayerKnowledge() {
        this(Set.of(), Map.of(), Map.of(), Map.of(), List.of(), Optional.empty(), Optional.empty(), 1, 0L);
    }

    protected PlayerKnowledge(Set<AbstractResearchKey<?>> research, Map<AbstractResearchKey<?>, Integer> stages, Map<AbstractResearchKey<?>, Set<IPlayerKnowledge.ResearchFlag>> flags, Map<KnowledgeType, Integer> knowledge, List<AbstractResearchTopic<?>> topicHistory, Optional<Project> project, Optional<AbstractResearchTopic<?>> topic, int schemaVersion, long syncTimestamp) {
        this.research.addAll(research);
        this.stages.putAll(stages);
        this.flags.putAll(flags);
        this.knowledge.putAll(knowledge);
        this.topicHistory.addAll(topicHistory);
        this.project = project;
        this.topic = topic;
        this.schemaVersion = schemaVersion;
        this.syncTimestamp = syncTimestamp;
    }

    @VisibleForTesting
    public int getSchemaVersion() {
        return this.schemaVersion;
    }

    @Override
    @Nullable
    public Tag serializeNBT(@NotNull HolderLookup.Provider registryAccess) {
        RegistryOps registryOps = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.syncTimestamp = System.currentTimeMillis();
        return CODEC.encodeStart((DynamicOps)registryOps, (Object)this).resultOrPartial(msg -> LOGGER.error("Failed to serialize player knowledge: {}", msg)).orElse(null);
    }

    @Override
    public synchronized void deserializeNBT(@NotNull HolderLookup.Provider registryAccess, @NotNull Tag nbt) {
        RegistryOps registryOps = registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        MutableObject parsedKnowledge = new MutableObject(null);
        CODEC.parse((DynamicOps)registryOps, (Object)nbt).ifSuccess(arg_0 -> ((Mutable)parsedKnowledge).setValue(arg_0)).ifError(arg_0 -> PlayerKnowledge.lambda$deserializeNBT$32(nbt, registryAccess, (Mutable)parsedKnowledge, arg_0));
        this.copyFrom((PlayerKnowledge)parsedKnowledge.getValue());
        if (this.schemaVersion < 1) {
            this.research.stream().map(ark -> {
                ResearchEntryKey rek;
                return ark instanceof ResearchEntryKey ? (rek = (ResearchEntryKey)ark) : null;
            }).filter(Objects::nonNull).filter(this::isReadByDefault).forEach(k -> this.addResearchFlag((AbstractResearchKey<?>)k, IPlayerKnowledge.ResearchFlag.READ));
        }
        this.schemaVersion = 1;
    }

    protected boolean isReadByDefault(ResearchEntryKey key) {
        return this.research.contains(key) && !this.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.NEW) && !this.hasResearchFlag(key, IPlayerKnowledge.ResearchFlag.UPDATED);
    }

    public void copyFrom(@Nullable PlayerKnowledge other) {
        if (other == null || other.syncTimestamp <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = other.syncTimestamp;
        this.clearResearch();
        this.clearKnowledge();
        this.research.addAll(other.research);
        this.stages.putAll(other.stages);
        this.flags.putAll(other.flags);
        this.knowledge.putAll(other.knowledge);
        this.topicHistory.addAll(other.topicHistory);
        this.project = other.project;
        this.topic = other.topic;
        this.schemaVersion = other.schemaVersion;
    }

    @Deprecated(forRemoval=true, since="6.0.2-beta")
    @Nonnull
    @VisibleForTesting
    public CompoundTag serializeLegacyNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        ListTag researchList = new ListTag();
        for (AbstractResearchKey<?> key : this.research) {
            String str;
            Set<IPlayerKnowledge.ResearchFlag> researchFlags;
            CompoundTag tag = new CompoundTag();
            AbstractResearchKey.dispatchCodec().encodeStart((DynamicOps)registryOps, key).resultOrPartial(msg -> LOGGER.error("Failed to encode research entry in player knowledge capability: {}", msg)).ifPresent(encodedTag -> tag.put("key", encodedTag));
            if (this.stages.containsKey(key)) {
                tag.putInt("stage", this.stages.get(key).intValue());
            }
            if ((researchFlags = this.flags.get(key)) != null && (str = Arrays.stream((IPlayerKnowledge.ResearchFlag[])researchFlags.toArray(IPlayerKnowledge.ResearchFlag[]::new)).map(t -> t.name()).collect(Collectors.joining(","))) != null && !str.isEmpty()) {
                tag.putString("flags", str);
            }
            researchList.add((Object)tag);
        }
        rootTag.put("research", (Tag)researchList);
        ListTag knowledgeList = new ListTag();
        for (KnowledgeType knowledgeKey : this.knowledge.keySet()) {
            Integer points;
            if (knowledgeKey == null || (points = this.knowledge.get((Object)knowledgeKey)) == null || points <= 0) continue;
            CompoundTag tag = new CompoundTag();
            tag.putString("key", knowledgeKey.name());
            tag.putInt("value", points.intValue());
            knowledgeList.add((Object)tag);
        }
        rootTag.put("knowledge", (Tag)knowledgeList);
        this.project.ifPresent(value -> Project.codec().encodeStart((DynamicOps)registryOps, value).resultOrPartial(msg -> LOGGER.error("Failed to encode active research project in player knowledge capability: {}", msg)).ifPresent(encodedProject -> rootTag.put("project", encodedProject)));
        this.topic.ifPresent(topic -> AbstractResearchTopic.dispatchCodec().encodeStart((DynamicOps)registryOps, topic).resultOrPartial(msg -> LOGGER.error("Failed to encode current grimoire topic in player knowledge capability: {}", msg)).ifPresent(encodedTopic -> rootTag.put("topic", encodedTopic)));
        AbstractResearchTopic.dispatchCodec().listOf().encodeStart((DynamicOps)registryOps, this.topicHistory).resultOrPartial(msg -> LOGGER.error("Failed to encode grimoire topic history entry in player knowledge capability: {}", msg)).ifPresent(encodedHistory -> rootTag.put("topicHistory", encodedHistory));
        rootTag.putLong("syncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Deprecated(forRemoval=true, since="6.0.2-beta")
    @VisibleForTesting
    public synchronized void deserializeLegacyNBT(HolderLookup.Provider registries, @Nullable CompoundTag nbt) {
        if (nbt == null || nbt.getLong("syncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("syncTimestamp");
        this.clearResearch();
        this.clearKnowledge();
        RegistryOps registryOps = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.schemaVersion = nbt.getInt("schemaVersion");
        ListTag researchList = nbt.getList("research", 10);
        for (int index = 0; index < researchList.size(); ++index) {
            CompoundTag tag = researchList.getCompound(index);
            AbstractResearchKey.dispatchCodec().parse((DynamicOps)registryOps, (Object)tag.get("key")).resultOrPartial(msg -> LOGGER.error("Failed to decode research entry in player knowledge capability: {}", msg)).ifPresent(parsedKey -> {
                if (!this.isResearchKnown((AbstractResearchKey<?>)parsedKey)) {
                    String flagStr;
                    this.research.add((AbstractResearchKey<?>)parsedKey);
                    int stage = tag.getInt("stage");
                    if (stage > 0) {
                        this.stages.put((AbstractResearchKey<?>)parsedKey, stage);
                    }
                    if ((flagStr = tag.getString("flags")) != null && !flagStr.isEmpty()) {
                        for (String flagName : flagStr.split(",")) {
                            try {
                                this.addResearchFlag((AbstractResearchKey<?>)parsedKey, IPlayerKnowledge.ResearchFlag.valueOf(flagName));
                            }
                            catch (Exception e) {
                                LOGGER.warn("Invalid research flag name: " + flagName, (Throwable)e);
                            }
                        }
                    }
                }
            });
        }
        ListTag knowledgeList = nbt.getList("knowledge", 10);
        for (int index = 0; index < knowledgeList.size(); ++index) {
            CompoundTag tag = knowledgeList.getCompound(index);
            String keyStr = tag.getString("key");
            KnowledgeType key = null;
            try {
                key = KnowledgeType.valueOf(keyStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int points = tag.getInt("value");
            if (key == null) continue;
            this.knowledge.put(key, points);
        }
        if (nbt.contains("project")) {
            Project.codec().parse((DynamicOps)registryOps, (Object)nbt.getCompound("project")).resultOrPartial(msg -> LOGGER.error("Failed to decode active research project in player knowledge capability: {}", msg)).ifPresent(project -> {
                this.project = Optional.ofNullable(project);
            });
        }
        if (nbt.contains("topic")) {
            AbstractResearchTopic.dispatchCodec().parse((DynamicOps)registryOps, (Object)nbt.get("topic")).resultOrPartial(msg -> LOGGER.error("Failed to decode current grimoire topic in player knowledge capability: {}", msg)).ifPresent(decodedTopic -> {
                this.topic = Optional.ofNullable(decodedTopic);
            });
        }
        AbstractResearchTopic.dispatchCodec().listOf().parse((DynamicOps)registryOps, (Object)nbt.get("topicHistory")).resultOrPartial(msg -> LOGGER.error("Failed to decode grimoire topic history entry in player knowledge capability: {}", msg)).ifPresent(decodedHistory -> this.topicHistory.addAll((Collection<AbstractResearchTopic<?>>)decodedHistory));
    }

    @Override
    public void clearResearch() {
        this.research.clear();
        this.stages.clear();
        this.flags.clear();
        this.project = Optional.empty();
        this.topic = Optional.empty();
        this.topicHistory.clear();
    }

    @Override
    public void clearKnowledge() {
        this.knowledge.clear();
    }

    @Override
    @Nonnull
    public Set<AbstractResearchKey<?>> getResearchSet() {
        return Collections.unmodifiableSet(this.research);
    }

    @Override
    @Nonnull
    public IPlayerKnowledge.ResearchStatus getResearchStatus(@Nonnull RegistryAccess registryAccess, @Nullable AbstractResearchKey<?> research) {
        if (!this.isResearchKnown(research)) {
            return IPlayerKnowledge.ResearchStatus.UNKNOWN;
        }
        if (research instanceof ResearchEntryKey) {
            ResearchEntryKey entryKey = (ResearchEntryKey)research;
            ResearchEntry entry = ResearchEntries.getEntry(registryAccess, entryKey);
            if (entry == null || entry.stages().isEmpty() || this.getResearchStage(research) >= entry.stages().size()) {
                return IPlayerKnowledge.ResearchStatus.COMPLETE;
            }
            return IPlayerKnowledge.ResearchStatus.IN_PROGRESS;
        }
        return IPlayerKnowledge.ResearchStatus.COMPLETE;
    }

    @Override
    public boolean isResearchComplete(@Nonnull RegistryAccess registryAccess, @Nullable AbstractResearchKey<?> research) {
        return this.getResearchStatus(registryAccess, research) == IPlayerKnowledge.ResearchStatus.COMPLETE;
    }

    @Override
    public boolean isResearchKnown(@Nullable AbstractResearchKey<?> research) {
        if (research == null) {
            return false;
        }
        return this.research.contains(research);
    }

    @Override
    public int getResearchStage(@Nullable AbstractResearchKey<?> research) {
        if (research == null || !this.research.contains(research)) {
            return -1;
        }
        return this.stages.getOrDefault(research, 0);
    }

    @Override
    public boolean addResearch(@Nullable AbstractResearchKey<?> research) {
        if (research != null && !this.isResearchKnown(research)) {
            this.research.add(research);
            return true;
        }
        return false;
    }

    @Override
    public boolean setResearchStage(@Nullable AbstractResearchKey<?> research, int newStage) {
        if (research == null || !this.research.contains(research) || newStage <= 0) {
            return false;
        }
        this.stages.put(research, newStage);
        return true;
    }

    @Override
    public boolean removeResearch(@Nullable AbstractResearchKey<?> research) {
        if (research != null && this.isResearchKnown(research)) {
            this.research.remove(research);
            return true;
        }
        return false;
    }

    @Override
    public boolean addResearchFlag(@Nullable AbstractResearchKey<?> research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        return this.flags.computeIfAbsent(research, $ -> EnumSet.noneOf(IPlayerKnowledge.ResearchFlag.class)).add(flag);
    }

    @Override
    public boolean removeResearchFlag(@Nullable AbstractResearchKey<?> research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        return this.removeResearchFlagInner(research, flag);
    }

    protected boolean removeResearchFlagInner(@Nonnull AbstractResearchKey<?> research, @Nonnull IPlayerKnowledge.ResearchFlag flag) {
        Set<IPlayerKnowledge.ResearchFlag> researchFlags = this.flags.get(research);
        if (researchFlags != null) {
            boolean retVal = researchFlags.remove((Object)flag);
            if (researchFlags.isEmpty()) {
                this.flags.remove(research);
            }
            return retVal;
        }
        return false;
    }

    @Override
    public boolean hasResearchFlag(@Nullable AbstractResearchKey<?> research, @Nullable IPlayerKnowledge.ResearchFlag flag) {
        if (research == null || flag == null) {
            return false;
        }
        Set<IPlayerKnowledge.ResearchFlag> researchFlags = this.flags.get(research);
        return researchFlags != null && researchFlags.contains((Object)flag);
    }

    @Override
    @Nonnull
    public Set<IPlayerKnowledge.ResearchFlag> getResearchFlags(@Nullable AbstractResearchKey<?> research) {
        if (research == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet((Set)this.flags.getOrDefault(research, EnumSet.noneOf(IPlayerKnowledge.ResearchFlag.class)));
    }

    @Override
    public boolean addKnowledge(@Nullable KnowledgeType type, int amount) {
        if (type == null) {
            return false;
        }
        int points = this.getKnowledgeRaw(type) + amount;
        if (points < 0) {
            return false;
        }
        this.knowledge.put(type, points);
        return true;
    }

    @Override
    public int getKnowledge(@Nullable KnowledgeType type) {
        if (type == null) {
            return 0;
        }
        return (int)Math.floor((double)this.getKnowledgeRaw(type) / (double)type.getProgression());
    }

    @Override
    public int getKnowledgeRaw(@Nullable KnowledgeType type) {
        if (type == null) {
            return 0;
        }
        return this.knowledge.getOrDefault((Object)type, 0);
    }

    @Override
    public Project getActiveResearchProject() {
        return this.project.orElse(null);
    }

    @Override
    public void setActiveResearchProject(Project project) {
        this.project = Optional.ofNullable(project);
    }

    @Override
    public AbstractResearchTopic<?> getLastResearchTopic() {
        return this.topic.orElse(MainIndexResearchTopic.INSTANCE);
    }

    @Override
    public void setLastResearchTopic(AbstractResearchTopic<?> topic) {
        this.topic = Optional.ofNullable(topic);
    }

    @Override
    public LinkedList<AbstractResearchTopic<?>> getResearchTopicHistory() {
        return this.topicHistory;
    }

    @Override
    public void setResearchTopicHistory(List<AbstractResearchTopic<?>> history) {
        this.topicHistory.clear();
        this.topicHistory.addAll(history);
    }

    @Override
    public void sync(@Nullable ServerPlayer player) {
        if (player != null) {
            this.syncTimestamp = System.currentTimeMillis();
            RegistryOps registryOps = player.level().registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            CODEC.encodeStart((DynamicOps)registryOps, (Object)this).resultOrPartial(err -> LOGGER.error("Failed to encode knowledge data for syncing")).ifPresent(tag -> CODEC.parse((DynamicOps)registryOps, tag).resultOrPartial(err -> LOGGER.error("Failed to parse knowledge data for syncing")).ifPresent(knowledge -> PacketHandler.sendToPlayer(new SyncKnowledgePacket((PlayerKnowledge)knowledge), player)));
            this.flags.keySet().forEach(key -> this.removeResearchFlagInner((AbstractResearchKey<?>)key, IPlayerKnowledge.ResearchFlag.POPUP));
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof PlayerKnowledge)) {
            return false;
        }
        PlayerKnowledge that = (PlayerKnowledge)o;
        return Objects.equals(this.research, that.research) && Objects.equals(this.stages, that.stages) && Objects.equals(this.flags, that.flags) && Objects.equals(this.knowledge, that.knowledge) && Objects.equals(this.topicHistory, that.topicHistory) && Objects.equals(this.project, that.project) && Objects.equals(this.topic, that.topic);
    }

    public int hashCode() {
        return Objects.hash(this.research, this.stages, this.flags, this.knowledge, this.topicHistory, this.project, this.topic);
    }

    private static /* synthetic */ void lambda$deserializeNBT$32(Tag nbt, HolderLookup.Provider registryAccess, Mutable parsedKnowledge, DataResult.Error err) {
        LOGGER.warn("Failed to deserialize player knowledge using codec, trying fallback");
        if (nbt instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)nbt;
            PlayerKnowledge legacyKnowledge = new PlayerKnowledge();
            legacyKnowledge.deserializeLegacyNBT(registryAccess, compoundTag);
            parsedKnowledge.setValue((Object)legacyKnowledge);
        }
    }

    protected record FlagsEntry(AbstractResearchKey<?> key, Set<IPlayerKnowledge.ResearchFlag> flagSet) {
        public static final Codec<FlagsEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractResearchKey.dispatchCodec().fieldOf("key").forGetter(FlagsEntry::key), (App)IPlayerKnowledge.ResearchFlag.CODEC.listOf().xmap(HashSet::new, ImmutableList::copyOf).fieldOf("flagSet").forGetter(FlagsEntry::flagSet)).apply((Applicative)instance, FlagsEntry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FlagsEntry> STREAM_CODEC = StreamCodec.composite(AbstractResearchKey.dispatchStreamCodec(), FlagsEntry::key, (StreamCodec)IPlayerKnowledge.ResearchFlag.STREAM_CODEC.apply(ByteBufCodecs.list()).map(HashSet::new, ImmutableList::copyOf), FlagsEntry::flagSet, FlagsEntry::new);
    }

    protected record StageEntry(AbstractResearchKey<?> key, int stage) {
        public static final Codec<StageEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AbstractResearchKey.dispatchCodec().fieldOf("key").forGetter(StageEntry::key), (App)Codec.INT.fieldOf("stage").forGetter(StageEntry::stage)).apply((Applicative)instance, StageEntry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, StageEntry> STREAM_CODEC = StreamCodec.composite(AbstractResearchKey.dispatchStreamCodec(), StageEntry::key, (StreamCodec)ByteBufCodecs.VAR_INT, StageEntry::stage, StageEntry::new);
    }
}

