/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCooldowns;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncCooldownsPacket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerCooldowns
implements IPlayerCooldowns {
    private final Map<IPlayerCooldowns.CooldownType, Long> cooldowns = new ConcurrentHashMap<IPlayerCooldowns.CooldownType, Long>();
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag cooldownList = new ListTag();
        for (IPlayerCooldowns.CooldownType type : this.cooldowns.keySet()) {
            Long time;
            if (type == null || (time = this.cooldowns.get((Object)type)) == null || time <= 0L) continue;
            CompoundTag tag = new CompoundTag();
            tag.putString("Type", type.name());
            tag.putLong("Value", time.longValue());
            cooldownList.add((Object)tag);
        }
        rootTag.put("Cooldowns", (Tag)cooldownList);
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clearCooldowns();
        ListTag cooldownList = nbt.getList("Cooldowns", 10);
        for (int index = 0; index < cooldownList.size(); ++index) {
            CompoundTag tag = cooldownList.getCompound(index);
            IPlayerCooldowns.CooldownType type = null;
            try {
                type = IPlayerCooldowns.CooldownType.valueOf(tag.getString("Type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            long time = tag.getLong("Value");
            if (type == null) continue;
            this.cooldowns.put(type, time);
        }
    }

    @Override
    public boolean isOnCooldown(IPlayerCooldowns.CooldownType type) {
        if (type == null) {
            return false;
        }
        return this.cooldowns.getOrDefault((Object)type, 0L) > System.currentTimeMillis();
    }

    @Override
    public long getRemainingCooldown(IPlayerCooldowns.CooldownType type) {
        return Math.max(0L, this.cooldowns.getOrDefault((Object)type, 0L) - System.currentTimeMillis());
    }

    @Override
    public void setCooldown(IPlayerCooldowns.CooldownType type, int durationTicks) {
        if (type != null) {
            this.cooldowns.put(type, System.currentTimeMillis() + (long)(durationTicks * 50));
        }
    }

    @Override
    public void clearCooldowns() {
        this.cooldowns.clear();
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncCooldownsPacket((Player)player), player);
        }
    }
}

