/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerCompanions;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncCompanionsPacket;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerCompanions
implements IPlayerCompanions {
    private final Map<IPlayerCompanions.CompanionType, LinkedList<UUID>> companions = new ConcurrentHashMap<IPlayerCompanions.CompanionType, LinkedList<UUID>>();
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        for (IPlayerCompanions.CompanionType type : IPlayerCompanions.CompanionType.values()) {
            ListTag list = new ListTag();
            List<UUID> companions = this.get(type);
            for (UUID id : companions) {
                CompoundTag companionTag = new CompoundTag();
                companionTag.putUUID("Id", id);
                list.add((Object)companionTag);
            }
            rootTag.put(type.getSerializedName(), (Tag)list);
        }
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clear();
        for (IPlayerCompanions.CompanionType type : IPlayerCompanions.CompanionType.values()) {
            if (!nbt.contains(type.getSerializedName(), 9)) continue;
            ListTag list = nbt.getList(type.getSerializedName(), 10);
            for (int index = 0; index < list.size(); ++index) {
                CompoundTag companionTag = list.getCompound(index);
                if (!companionTag.hasUUID("Id")) continue;
                this.companions.computeIfAbsent(type, t -> new LinkedList()).add(companionTag.getUUID("Id"));
            }
        }
    }

    @Override
    public UUID add(IPlayerCompanions.CompanionType type, UUID id) {
        LinkedList list = this.companions.computeIfAbsent(type, t -> new LinkedList());
        if (list.contains(id)) {
            return null;
        }
        list.add(id);
        if (list.size() > type.getLimit()) {
            return (UUID)list.pollFirst();
        }
        return null;
    }

    @Override
    public boolean contains(IPlayerCompanions.CompanionType type, UUID id) {
        return this.companions.getOrDefault((Object)type, new LinkedList()).contains(id);
    }

    @Override
    public List<UUID> get(IPlayerCompanions.CompanionType type) {
        return Collections.unmodifiableList(this.companions.getOrDefault((Object)type, new LinkedList()));
    }

    @Override
    public boolean remove(IPlayerCompanions.CompanionType type, UUID id) {
        return this.companions.getOrDefault((Object)type, new LinkedList()).remove(id);
    }

    @Override
    public void clear() {
        this.companions.clear();
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncCompanionsPacket((Player)player), player);
        }
    }
}

