/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerAttunements;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncAttunementsPacket;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.Sources;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class PlayerAttunements
implements IPlayerAttunements {
    private final Map<Source, Map<AttunementType, Integer>> attunements = new ConcurrentHashMap<Source, Map<AttunementType, Integer>>();
    private final Set<Source> suppressions = ConcurrentHashMap.newKeySet();
    private long syncTimestamp = 0L;

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag attunementList = new ListTag();
        for (Map.Entry<Source, Map<AttunementType, Integer>> sourceEntry : this.attunements.entrySet()) {
            if (sourceEntry == null) continue;
            for (Map.Entry<AttunementType, Integer> typeEntry : sourceEntry.getValue().entrySet()) {
                if (typeEntry == null || sourceEntry.getKey() == null || typeEntry.getKey() == null || typeEntry.getValue() == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.putString("Source", sourceEntry.getKey().getId().toString());
                tag.putString("Type", typeEntry.getKey().name());
                tag.putInt("Value", typeEntry.getValue().intValue());
                attunementList.add((Object)tag);
            }
        }
        rootTag.put("Attunements", (Tag)attunementList);
        ListTag suppressionList = new ListTag();
        for (Source source : this.suppressions) {
            if (source == null) continue;
            suppressionList.add((Object)StringTag.valueOf((String)source.getId().toString()));
        }
        rootTag.put("Suppressions", (Tag)suppressionList);
        rootTag.putLong("SyncTimestamp", System.currentTimeMillis());
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        Source source;
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.clear();
        ListTag attunementList = nbt.getList("Attunements", 10);
        for (int index = 0; index < attunementList.size(); ++index) {
            CompoundTag tag = attunementList.getCompound(index);
            source = Sources.get(ResourceLocation.parse((String)tag.getString("Source")));
            AttunementType type = null;
            try {
                type = AttunementType.valueOf(tag.getString("Type"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            int value = tag.getInt("Value");
            this.setValue(source, type, value);
        }
        ListTag suppressionList = nbt.getList("Suppressions", 8);
        for (int index = 0; index < suppressionList.size(); ++index) {
            source = Sources.get(ResourceLocation.parse((String)suppressionList.getString(index)));
            this.setSuppressed(source, true);
        }
    }

    @Override
    public void clear() {
        this.attunements.clear();
        this.suppressions.clear();
    }

    @Override
    public int getValue(Source source, AttunementType type) {
        return this.attunements.getOrDefault(source, Collections.emptyMap()).getOrDefault((Object)type, 0);
    }

    @Override
    public void setValue(Source source, AttunementType type, int value) {
        if (source != null && type != null) {
            Map typeMap = this.attunements.computeIfAbsent(source, k -> new ConcurrentHashMap());
            int toSet = type.isCapped() ? Mth.clamp((int)value, (int)0, (int)type.getMaximum()) : Math.max(0, value);
            typeMap.put(type, toSet);
        }
    }

    @Override
    public boolean isSuppressed(Source source) {
        return this.suppressions.contains(source);
    }

    @Override
    public void setSuppressed(Source source, boolean value) {
        if (source != null) {
            boolean present = this.isSuppressed(source);
            if (!present && value) {
                this.suppressions.add(source);
            } else if (present && !value) {
                this.suppressions.remove(source);
            }
        }
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncAttunementsPacket((Player)player), player);
        }
    }
}

