/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IPlayerArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.crafting.recipe_book.ArcaneRecipeBook;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.data.SyncArcaneRecipeBookPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeManager;

public class PlayerArcaneRecipeBook
implements IPlayerArcaneRecipeBook {
    private final ArcaneRecipeBook book = new ArcaneRecipeBook();
    private long syncTimestamp = 0L;

    @Override
    public ArcaneRecipeBook get() {
        return this.book;
    }

    @Override
    public void sync(ServerPlayer player) {
        if (player != null) {
            PacketHandler.sendToPlayer(new SyncArcaneRecipeBookPacket((Player)player), player);
        }
    }

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag retVal = new CompoundTag();
        retVal.put("Book", (Tag)this.book.toNbt());
        retVal.putLong("SyncTimestamp", System.currentTimeMillis());
        return retVal;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt, RecipeManager recipeManager) {
        if (nbt == null || nbt.getLong("SyncTimestamp") <= this.syncTimestamp) {
            return;
        }
        this.syncTimestamp = nbt.getLong("SyncTimestamp");
        this.book.fromNbt(nbt.getCompound("Book"), recipeManager);
    }
}

