/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.capabilities.IManaStorage;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ManaStorage
implements IManaStorage<ManaStorage> {
    public static final Codec<ManaStorage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("capacity").forGetter(cap -> cap.capacity), (App)Codec.INT.fieldOf("maxReceive").forGetter(cap -> cap.maxReceive), (App)Codec.INT.fieldOf("maxExtract").forGetter(cap -> cap.maxExtract), (App)SourceList.CODEC.fieldOf("mana").forGetter(cap -> cap.mana), (App)Source.CODEC.listOf().fieldOf("allowedSources").xmap(HashSet::new, ArrayList::new).forGetter(cap -> cap.allowedSources)).apply((Applicative)instance, ManaStorage::new));
    public static final StreamCodec<ByteBuf, ManaStorage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, cap -> cap.capacity, (StreamCodec)ByteBufCodecs.VAR_INT, cap -> cap.maxReceive, (StreamCodec)ByteBufCodecs.VAR_INT, cap -> cap.maxExtract, SourceList.STREAM_CODEC, cap -> cap.mana, (StreamCodec)Source.STREAM_CODEC.apply(ByteBufCodecs.collection(HashSet::new)), cap -> cap.allowedSources, ManaStorage::new);
    public static final ManaStorage EMPTY = new ManaStorage(0, 0, 0, SourceList.EMPTY, (Collection<Source>)ImmutableList.of());
    public static final int INFINITE = -1;
    protected int capacity;
    protected int maxReceive;
    protected int maxExtract;
    protected SourceList mana;
    protected Set<Source> allowedSources;

    public ManaStorage(int capacity, Source ... allowedSources) {
        this(capacity, capacity, capacity, SourceList.EMPTY, allowedSources);
    }

    public ManaStorage(int capacity, int maxTransfer, Source ... allowedSources) {
        this(capacity, maxTransfer, maxTransfer, SourceList.EMPTY, allowedSources);
    }

    public ManaStorage(int capacity, int maxReceive, int maxExtract, Source ... allowedSources) {
        this(capacity, maxReceive, maxExtract, SourceList.EMPTY, allowedSources);
    }

    public ManaStorage(int capacity, int maxReceive, int maxExtract, SourceList mana, Source ... allowedSources) {
        this(capacity, maxReceive, maxExtract, mana, Arrays.asList(allowedSources));
    }

    public ManaStorage(int capacity, int maxReceive, int maxExtract, SourceList mana, Collection<Source> allowedSources) {
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.allowedSources = new HashSet<Source>(allowedSources);
        this.mana = SourceList.EMPTY;
        this.setMana(mana);
    }

    @NotNull
    public static ManaStorage emptyWand(int capacity) {
        return new ManaStorage(capacity, Integer.MAX_VALUE, Integer.MAX_VALUE, SourceList.EMPTY, Sources.getAllSorted());
    }

    @NotNull
    public static ManaStorage emptyManaOrb(Source source, int capacity) {
        return new ManaStorage(capacity, Integer.MAX_VALUE, Integer.MAX_VALUE, SourceList.EMPTY, source);
    }

    @Override
    public Codec<ManaStorage> codec() {
        return CODEC;
    }

    @Override
    public StreamCodec<? super RegistryFriendlyByteBuf, ManaStorage> streamCodec() {
        return STREAM_CODEC;
    }

    public void copyManaInto(ManaStorage other) {
        other.setMana(this.mana);
    }

    public ManaStorage copy() {
        return new ManaStorage(this.capacity, this.maxReceive, this.maxExtract, this.mana, new HashSet<Source>(this.allowedSources));
    }

    public ManaStorage copyWith(Source source, int amount) {
        ManaStorage retVal = this.copy();
        retVal.setMana(source, amount);
        return retVal;
    }

    public void setMana(SourceList mana) {
        this.mana = SourceList.EMPTY;
        for (Source source : mana.getSources()) {
            this.setMana(source, mana.getAmount(source));
        }
    }

    public void setMana(Source source, int amount) {
        if (this.canStore(source) && this.capacity != -1) {
            this.mana = this.mana.set(source, Mth.clamp((int)amount, (int)0, (int)this.capacity));
        }
    }

    @Override
    public int receiveMana(Source source, int maxReceive, boolean simulate) {
        if (!this.canReceive(source) || this.capacity == -1) {
            return 0;
        }
        int manaReceived = Math.min(this.capacity - this.mana.getAmount(source), Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.mana = this.mana.add(source, manaReceived);
            this.onManaChanged();
        }
        return manaReceived;
    }

    @Override
    public int extractMana(Source source, int maxExtract, boolean simulate) {
        if (!this.canExtract(source)) {
            return 0;
        }
        if (this.capacity == -1) {
            return maxExtract;
        }
        int manaExtracted = Math.min(this.mana.getAmount(source), Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.mana = this.mana.reduce(source, manaExtracted);
            this.onManaChanged();
        }
        return manaExtracted;
    }

    @Override
    public SourceList getAllManaStored() {
        if (this.capacity == -1) {
            SourceList.Builder builder = SourceList.builder();
            Sources.getAll().forEach(s -> builder.with((Source)s, Integer.MAX_VALUE));
            return builder.build();
        }
        return this.mana.copy();
    }

    @Override
    public int getManaStored(Source source) {
        return this.capacity == -1 ? Integer.MAX_VALUE : this.mana.getAmount(source);
    }

    @Override
    public int getMaxManaStored(Source source) {
        return this.canStore(source) ? this.capacity : 0;
    }

    @Override
    public boolean canStore(Source source) {
        return this.allowedSources.contains(source);
    }

    @Override
    public boolean canExtract(Source source) {
        return this.canStore(source) && this.maxExtract > 0 && this.getManaStored(source) > 0;
    }

    @Override
    public boolean canReceive(Source source) {
        return this.canStore(source) && this.maxReceive > 0 && this.getManaStored(source) < this.getMaxManaStored(source);
    }

    protected void onManaChanged() {
    }

    public int hashCode() {
        return Objects.hash(this.allowedSources, this.capacity, this.mana, this.maxExtract, this.maxReceive);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManaStorage other = (ManaStorage)obj;
        return Objects.equals(this.allowedSources, other.allowedSources) && this.capacity == other.capacity && Objects.equals(this.mana, other.mana) && this.maxExtract == other.maxExtract && this.maxReceive == other.maxReceive;
    }
}

