/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.research.KnowledgeType;
import com.verdantartifice.primalmagick.common.research.keys.AbstractResearchKey;
import com.verdantartifice.primalmagick.common.research.topics.AbstractResearchTopic;
import com.verdantartifice.primalmagick.common.theorycrafting.Project;
import com.verdantartifice.primalmagick.common.util.INBTSerializablePM;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public interface IPlayerKnowledge
extends INBTSerializablePM<Tag> {
    public void clearResearch();

    public void clearKnowledge();

    @Nonnull
    public Set<AbstractResearchKey<?>> getResearchSet();

    @Nonnull
    public ResearchStatus getResearchStatus(@Nonnull RegistryAccess var1, @Nullable AbstractResearchKey<?> var2);

    public boolean isResearchComplete(@Nonnull RegistryAccess var1, @Nullable AbstractResearchKey<?> var2);

    public boolean isResearchKnown(@Nullable AbstractResearchKey<?> var1);

    public int getResearchStage(@Nullable AbstractResearchKey<?> var1);

    public boolean addResearch(@Nullable AbstractResearchKey<?> var1);

    public boolean setResearchStage(@Nullable AbstractResearchKey<?> var1, int var2);

    public boolean removeResearch(@Nullable AbstractResearchKey<?> var1);

    public boolean addResearchFlag(@Nullable AbstractResearchKey<?> var1, @Nullable ResearchFlag var2);

    public boolean removeResearchFlag(@Nullable AbstractResearchKey<?> var1, @Nullable ResearchFlag var2);

    public boolean hasResearchFlag(@Nullable AbstractResearchKey<?> var1, @Nullable ResearchFlag var2);

    @Nonnull
    public Set<ResearchFlag> getResearchFlags(@Nullable AbstractResearchKey<?> var1);

    public boolean addKnowledge(@Nullable KnowledgeType var1, int var2);

    public int getKnowledge(@Nullable KnowledgeType var1);

    public int getKnowledgeRaw(@Nullable KnowledgeType var1);

    public Project getActiveResearchProject();

    public void setActiveResearchProject(Project var1);

    public AbstractResearchTopic<?> getLastResearchTopic();

    public void setLastResearchTopic(AbstractResearchTopic<?> var1);

    public LinkedList<AbstractResearchTopic<?>> getResearchTopicHistory();

    public void setResearchTopicHistory(List<AbstractResearchTopic<?>> var1);

    public void sync(@Nullable ServerPlayer var1);

    public static enum ResearchFlag implements StringRepresentable
    {
        NEW(0, "new"),
        UPDATED(1, "updated"),
        POPUP(2, "popup"),
        HIGHLIGHT(3, "highlight"),
        READ(4, "read");

        private static final IntFunction<ResearchFlag> BY_ID;
        public static final Codec<ResearchFlag> CODEC;
        public static final StreamCodec<ByteBuf, ResearchFlag> STREAM_CODEC;
        private final int id;
        private final String name;

        private ResearchFlag(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(ResearchFlag::getId, (Object[])ResearchFlag.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromValues(ResearchFlag::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, ResearchFlag::getId);
        }
    }

    public static enum ResearchStatus {
        UNKNOWN,
        IN_PROGRESS,
        COMPLETE;

    }
}

