/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.mojang.serialization.Codec;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public interface IManaStorage<T extends IManaStorage<T>> {
    public Codec<T> codec();

    public StreamCodec<? super RegistryFriendlyByteBuf, T> streamCodec();

    public int receiveMana(Source var1, int var2, boolean var3);

    public int extractMana(Source var1, int var2, boolean var3);

    public SourceList getAllManaStored();

    public int getManaStored(Source var1);

    public int getMaxManaStored(Source var1);

    public boolean canStore(Source var1);

    public boolean canExtract(Source var1);

    public boolean canReceive(Source var1);

    default public boolean isEmpty() {
        return Sources.stream().filter(this::canStore).allMatch(s -> this.getManaStored((Source)s) == 0);
    }

    default public boolean isFull() {
        return Sources.stream().filter(this::canStore).noneMatch(s -> this.getManaStored((Source)s) < this.getMaxManaStored((Source)s));
    }
}

