/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IFluidHandlerPM;
import com.verdantartifice.primalmagick.common.fluids.FluidStackPMNeoforge;
import com.verdantartifice.primalmagick.common.fluids.IFluidStackPM;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class FluidHandlerPMNeoforge
implements IFluidHandlerPM {
    public static final IFluidHandlerPM EMPTY = new FluidHandlerPMNeoforge(0, fs -> false);
    protected final FluidTank tank;

    public FluidHandlerPMNeoforge(int capacity) {
        this(capacity, fs -> true);
    }

    public FluidHandlerPMNeoforge(int capacity, Predicate<IFluidStackPM> validator) {
        this.tank = new FluidTank(capacity, nfStack -> validator.test(new FluidStackPMNeoforge((FluidStack)nfStack)));
    }

    public IFluidHandler getInner() {
        return this.tank;
    }

    @Override
    public int getTanks() {
        return this.tank.getTanks();
    }

    @Override
    public IFluidStackPM getFluidInTank(int tank) {
        return new FluidStackPMNeoforge(this.tank.getFluidInTank(tank));
    }

    @Override
    public int getTankCapacity(int tank) {
        return this.tank.getTankCapacity(tank);
    }

    @Override
    public boolean isFluidValid(int tank, IFluidStackPM stack) {
        FluidStackPMNeoforge nfStack;
        return stack instanceof FluidStackPMNeoforge && this.tank.isFluidValid(tank, (nfStack = (FluidStackPMNeoforge)stack).getInner());
    }

    @Override
    public int fill(IFluidStackPM stack, boolean simulate) {
        if (stack instanceof FluidStackPMNeoforge) {
            FluidStackPMNeoforge nfStack = (FluidStackPMNeoforge)stack;
            return this.tank.fill(nfStack.getInner(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
        }
        return 0;
    }

    @Override
    public IFluidStackPM drain(IFluidStackPM stack, boolean simulate) {
        if (stack instanceof FluidStackPMNeoforge) {
            FluidStackPMNeoforge nfStack = (FluidStackPMNeoforge)stack;
            return new FluidStackPMNeoforge(this.tank.drain(nfStack.getInner(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
        }
        return FluidStackPMNeoforge.EMPTY;
    }

    @Override
    public IFluidStackPM drain(int maxDrain, boolean simulate) {
        return new FluidStackPMNeoforge(this.tank.drain(maxDrain, simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    public IFluidHandlerPM readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        this.tank.readFromNBT(lookupProvider, nbt.getCompound("Tank"));
        return this;
    }

    @Override
    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        nbt.put("Tank", (Tag)this.tank.writeToNBT(lookupProvider, new CompoundTag()));
        return nbt;
    }
}

