/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.capabilities;

import com.verdantartifice.primalmagick.common.capabilities.IEntitySwappers;
import com.verdantartifice.primalmagick.common.misc.EntitySwapper;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class EntitySwappers
implements IEntitySwappers {
    private final Queue<EntitySwapper> swappers = new LinkedBlockingQueue<EntitySwapper>();

    @Override
    public CompoundTag serializeNBT(HolderLookup.Provider registries) {
        CompoundTag rootTag = new CompoundTag();
        ListTag swapperList = new ListTag();
        for (EntitySwapper swapper : this.swappers) {
            if (swapper == null) continue;
            swapperList.add((Object)swapper.serializeNBT(registries));
        }
        rootTag.put("Swappers", (Tag)swapperList);
        return rootTag;
    }

    @Override
    public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        this.swappers.clear();
        ListTag swapperList = nbt.getList("Swappers", 10);
        for (int index = 0; index < swapperList.size(); ++index) {
            CompoundTag swapperTag = swapperList.getCompound(index);
            EntitySwapper swapper = new EntitySwapper(registries, swapperTag);
            if (!swapper.isValid()) continue;
            this.swappers.offer(swapper);
        }
    }

    @Override
    public boolean enqueue(EntitySwapper swapper) {
        if (swapper == null) {
            return false;
        }
        return this.swappers.offer(swapper);
    }

    @Override
    public Queue<EntitySwapper> getQueue() {
        return this.swappers;
    }

    @Override
    public boolean setQueue(Queue<EntitySwapper> queue) {
        if (queue == null) {
            return false;
        }
        this.swappers.clear();
        for (EntitySwapper swapper : queue) {
            this.enqueue(swapper);
        }
        return true;
    }
}

