/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books.grids.rewards;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.books.grids.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.books.grids.rewards.GridRewardType;
import com.verdantartifice.primalmagick.common.books.grids.rewards.GridRewardTypesPM;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ComprehensionReward
extends AbstractReward<ComprehensionReward> {
    private static final ResourceLocation ICON_LOC = ResourceUtils.loc("textures/gui/sprites/scribe_table/gain_comprehension.png");
    public static final MapCodec<ComprehensionReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec(RegistryKeysPM.BOOK_LANGUAGES).fieldOf("language").forGetter(r -> r.language), (App)Codec.INT.fieldOf("points").forGetter(r -> r.points)).apply((Applicative)instance, ComprehensionReward::new));
    public static final StreamCodec<ByteBuf, ComprehensionReward> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceKey.streamCodec(RegistryKeysPM.BOOK_LANGUAGES), r -> r.language, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.points, ComprehensionReward::new);
    private ResourceKey<BookLanguage> language;
    private int points;
    private Optional<Component> pointsText = Optional.empty();

    public ComprehensionReward(ResourceKey<BookLanguage> language, int points) {
        Verify.verifyNotNull(language, (String)"Invalid language for comprehension reward", (Object[])new Object[0]);
        this.language = language;
        this.setPoints(points);
    }

    @Override
    protected GridRewardType<ComprehensionReward> getType() {
        return GridRewardTypesPM.COMPREHENSION.get();
    }

    public int getPoints() {
        return this.points;
    }

    protected void setPoints(int points) {
        this.points = points;
        this.pointsText = Optional.of(Component.literal((String)Integer.toString(this.points)));
    }

    @Override
    public void grant(ServerPlayer player, RegistryAccess registryAccess) {
        BookLanguagesPM.getLanguage(this.language, registryAccess).ifPresent(langHolder -> LinguisticsManager.incrementComprehension((Player)player, (Holder<BookLanguage>)langHolder, this.points));
    }

    @Override
    public Component getDescription(Player player, RegistryAccess registryAccess) {
        MutableComponent amountText = Component.translatable((String)("label.primalmagick.comprehension_gain." + Mth.clamp((int)this.points, (int)0, (int)5)));
        MutableComponent langText = ((BookLanguage)BookLanguagesPM.getLanguageOrDefault(this.language, registryAccess, BookLanguagesPM.DEFAULT).value()).getName();
        return Component.translatable((String)"label.primalmagick.scribe_table.grid.reward.comprehension", (Object[])new Object[]{langText, amountText});
    }

    @Override
    public ResourceLocation getIconLocation(Player player) {
        return ICON_LOC;
    }

    @Override
    public Optional<Component> getAmountText() {
        return this.pointsText;
    }

    public static class Builder {
        protected final ResourceKey<BookLanguage> language;
        protected int points = 0;

        protected Builder(ResourceKey<BookLanguage> language) {
            this.language = (ResourceKey)Preconditions.checkNotNull(language);
        }

        public static Builder reward(ResourceKey<BookLanguage> language) {
            return new Builder(language);
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        private void validate() {
            if (this.points < 0) {
                throw new IllegalStateException("Points value must be non-negative");
            }
        }

        public ComprehensionReward build() {
            this.validate();
            return new ComprehensionReward(this.language, this.points);
        }
    }
}

