/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books.grids.rewards;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.attunements.AttunementManager;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.books.grids.rewards.AbstractReward;
import com.verdantartifice.primalmagick.common.books.grids.rewards.GridRewardType;
import com.verdantartifice.primalmagick.common.books.grids.rewards.GridRewardTypesPM;
import com.verdantartifice.primalmagick.common.sources.Source;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class AttunementReward
extends AbstractReward<AttunementReward> {
    public static final MapCodec<AttunementReward> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Source.CODEC.fieldOf("source").forGetter(r -> r.source), (App)Codec.INT.fieldOf("points").forGetter(r -> r.points)).apply((Applicative)instance, AttunementReward::new));
    public static final StreamCodec<ByteBuf, AttunementReward> STREAM_CODEC = StreamCodec.composite(Source.STREAM_CODEC, r -> r.source, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.points, AttunementReward::new);
    private Source source;
    private int points;
    private Optional<Component> pointsText = Optional.empty();

    public AttunementReward(Source source, int points) {
        Verify.verifyNotNull((Object)source, (String)"Invalid source for attunement reward", (Object[])new Object[0]);
        this.source = source;
        this.setPoints(points);
    }

    @Override
    protected GridRewardType<AttunementReward> getType() {
        return GridRewardTypesPM.ATTUNEMENT.get();
    }

    protected void setPoints(int points) {
        this.points = points;
        this.pointsText = points > 1 ? Optional.of(Component.literal((String)Integer.toString(points))) : Optional.empty();
    }

    @Override
    public void grant(ServerPlayer player, RegistryAccess registryAccess) {
        AttunementManager.incrementAttunement((Player)player, this.source, AttunementType.PERMANENT, this.points);
    }

    @Override
    public Component getDescription(Player player, RegistryAccess registryAccess) {
        MutableComponent amountText = Component.translatable((String)("label.primalmagick.attunement_gain." + Mth.clamp((int)this.points, (int)0, (int)5)));
        MutableComponent sourceText = this.source.isDiscovered(player) ? this.source.getNameText() : Component.translatable((String)Source.getUnknownTranslationKey());
        return Component.translatable((String)"label.primalmagick.scribe_table.grid.reward.attunement", (Object[])new Object[]{sourceText, amountText});
    }

    @Override
    public ResourceLocation getIconLocation(Player player) {
        return this.source.isDiscovered(player) ? this.source.getImage() : Source.getUnknownImage();
    }

    @Override
    public Optional<Component> getAmountText() {
        return this.pointsText;
    }

    public static class Builder {
        protected final Source source;
        protected int points = 0;

        protected Builder(Source source) {
            this.source = (Source)Preconditions.checkNotNull((Object)source);
        }

        public static Builder reward(Source source) {
            return new Builder(source);
        }

        public Builder points(int points) {
            this.points = points;
            return this;
        }

        private void validate() {
            if (this.points < 0) {
                throw new IllegalStateException("Points value must be non-negative");
            }
        }

        public AttunementReward build() {
            this.validate();
            return new AttunementReward(this.source, this.points);
        }
    }
}

