/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books.grids;

import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.books.grids.GridDefinition;
import com.verdantartifice.primalmagick.common.books.grids.GridNodeDefinition;
import com.verdantartifice.primalmagick.common.books.grids.rewards.IReward;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.scribe_table.UnlockGridNodeActionPacket;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class PlayerGrid {
    protected final Player player;
    protected final GridDefinition definition;
    protected final Set<Vector2i> unlocked = new HashSet<Vector2i>();
    protected long lastModified = 0L;

    public PlayerGrid(Player player, GridDefinition definition) {
        this.player = player;
        this.definition = definition;
    }

    public PlayerGrid(Player player, GridDefinition definition, Set<Vector2i> unlocked, long lastModified) {
        this(player, definition);
        this.unlocked.addAll(unlocked);
        this.lastModified = lastModified;
    }

    public Player getPlayer() {
        return this.player;
    }

    public GridDefinition getDefinition() {
        return this.definition;
    }

    public Set<Vector2ic> getUnlocked() {
        return Collections.unmodifiableSet(this.unlocked);
    }

    public Stream<GridNodeDefinition> getLockedNodes() {
        return this.definition.getNodes().entrySet().stream().filter(e -> !this.unlocked.contains(e.getKey())).map(e -> (GridNodeDefinition)e.getValue());
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean unlock(int x, int y, RegistryAccess registryAccess) {
        return this.unlock(new Vector2i(x, y), registryAccess);
    }

    public boolean unlock(Vector2i node, RegistryAccess registryAccess) {
        if (!this.isUnlockable(node)) {
            return false;
        }
        Optional langHolderOpt = registryAccess.registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getHolder(this.definition.language);
        if (langHolderOpt.isEmpty()) {
            return false;
        }
        int cost = this.definition.nodes.get((Object)node).vocabularyCost;
        if (!this.player.getAbilities().instabuild && LinguisticsManager.getVocabulary(this.player, (Holder<BookLanguage>)((Holder)langHolderOpt.get())) < cost) {
            return false;
        }
        Level level = this.player.level();
        if (level.isClientSide) {
            PacketHandler.sendToServer(new UnlockGridNodeActionPacket(this.definition.getKey(), node));
            this.unlocked.add(node);
            return true;
        }
        MutableBoolean retVal = new MutableBoolean(false);
        Services.CAPABILITIES.linguistics(this.player).ifPresent(linguistics -> {
            if (linguistics.unlockNode(this.definition.getKey(), node)) {
                this.lastModified = linguistics.getGridLastModified(this.definition.getKey());
                if (!this.player.getAbilities().instabuild) {
                    LinguisticsManager.incrementVocabulary(this.player, (Holder<BookLanguage>)((Holder)langHolderOpt.get()), -cost);
                }
                IReward reward = this.definition.nodes.get(node).getReward();
                Player patt0$temp = this.player;
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    reward.grant(serverPlayer, registryAccess);
                }
                LinguisticsManager.scheduleSync(this.player);
                this.unlocked.add(node);
                retVal.setTrue();
            }
        });
        return retVal.getValue();
    }

    public boolean isUnlockable(Vector2i node) {
        if (node == null) {
            return false;
        }
        if (this.unlocked.contains(node)) {
            return false;
        }
        if (!this.definition.isValidPos(node)) {
            return false;
        }
        return this.definition.getStartPos().equals((Object)node) || this.unlocked.stream().anyMatch(v -> PlayerGrid.areAdjacent(node, v));
    }

    protected static boolean areAdjacent(Vector2i vec1, Vector2i vec2) {
        return vec1 != null && vec2 != null && vec1.gridDistance((Vector2ic)vec2) == 1L;
    }
}

