/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books.grids;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.books.grids.GridDefinition;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GridDefinitionLoader
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static GridDefinitionLoader INSTANCE;

    protected GridDefinitionLoader() {
        super(GSON, "linguistics_grids");
    }

    public static GridDefinitionLoader getOrCreateInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GridDefinitionLoader();
        }
        return INSTANCE;
    }

    public static GridDefinitionLoader getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Cannot retrieve GridDefinitionLoader until resources are loaded at least once");
        }
        return INSTANCE;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        LinguisticsManager.clearAllGridDefinitions();
        for (Map.Entry<ResourceLocation, JsonElement> entry : pObject.entrySet()) {
            ResourceLocation location = entry.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                GridDefinition.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(gridDef -> {
                    if (gridDef == null || !LinguisticsManager.registerGridDefinition(location, gridDef)) {
                        LOGGER.error("Failed to register linguistics grid definition {}", (Object)location);
                    }
                });
            }
            catch (Exception e) {
                LOGGER.error("Parsing error loading linguistics grid definition {}", (Object)location, (Object)e);
            }
        }
        LOGGER.info("Loaded {} linguistics grid definitions", (Object)LinguisticsManager.getAllGridDefinitions().size());
    }

    public void replaceGridDefinitions(Map<ResourceLocation, GridDefinition> gridDefinitions) {
        LinguisticsManager.clearAllGridDefinitions();
        for (Map.Entry<ResourceLocation, GridDefinition> entry : gridDefinitions.entrySet()) {
            if (entry.getValue() != null && LinguisticsManager.registerGridDefinition(entry.getKey(), entry.getValue())) continue;
            LOGGER.error("Failed to update linguistics grid {}", (Object)entry.getKey());
        }
        LOGGER.info("Updated {} linguistics grid definitions", (Object)LinguisticsManager.getAllGridDefinitions().size());
    }
}

