/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books.grids;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.grids.GridNodeDefinition;
import com.verdantartifice.primalmagick.common.books.grids.rewards.ComprehensionReward;
import com.verdantartifice.primalmagick.common.books.grids.rewards.IReward;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.util.CodecUtils;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.util.StreamCodecUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2i;

public class GridDefinition {
    public static final int MIN_POS = 0;
    public static final int MAX_POS = 7;
    protected ResourceLocation key;
    protected ResourceKey<BookLanguage> language;
    protected Vector2i startPos;
    protected final Map<Vector2i, GridNodeDefinition> nodes = new HashMap<Vector2i, GridNodeDefinition>();

    public static Codec<GridDefinition> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("key").forGetter(GridDefinition::getKey), (App)ResourceKey.codec(RegistryKeysPM.BOOK_LANGUAGES).fieldOf("language").forGetter(GridDefinition::getLanguage), (App)CodecUtils.VECTOR2I.fieldOf("startPos").forGetter(GridDefinition::getStartPos), (App)PlacedNode.codec().listOf().xmap(nodeList -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            nodeList.forEach(pn -> builder.put((Object)pn.pos(), (Object)pn.definition()));
            return builder.build();
        }, nodeMap -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            nodeMap.entrySet().forEach(entry -> builder.add((Object)new PlacedNode((Vector2i)entry.getKey(), (GridNodeDefinition)entry.getValue())));
            return builder.build();
        }).fieldOf("nodes").forGetter(GridDefinition::getNodes)).apply((Applicative)instance, GridDefinition::new));
    }

    public static StreamCodec<FriendlyByteBuf, GridDefinition> streamCodec() {
        return StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, GridDefinition::getKey, (StreamCodec)ResourceKey.streamCodec(RegistryKeysPM.BOOK_LANGUAGES), GridDefinition::getLanguage, StreamCodecUtils.VECTOR2I, GridDefinition::getStartPos, (StreamCodec)PlacedNode.streamCodec().apply(ByteBufCodecs.list()).map(nodeList -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            nodeList.forEach(pn -> builder.put((Object)pn.pos(), (Object)pn.definition()));
            return builder.build();
        }, nodeMap -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            nodeMap.entrySet().forEach(entry -> builder.add((Object)new PlacedNode((Vector2i)entry.getKey(), (GridNodeDefinition)entry.getValue())));
            return builder.build();
        }), GridDefinition::getNodes, GridDefinition::new);
    }

    protected GridDefinition(ResourceLocation key, ResourceKey<BookLanguage> language, Vector2i startPos, Map<Vector2i, GridNodeDefinition> nodes) {
        this.key = key;
        this.language = language;
        this.startPos = startPos;
        this.nodes.putAll(nodes);
    }

    public ResourceLocation getKey() {
        return this.key;
    }

    public ResourceKey<BookLanguage> getLanguage() {
        return this.language;
    }

    public Vector2i getStartPos() {
        return this.startPos;
    }

    public Map<Vector2i, GridNodeDefinition> getNodes() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public boolean isValidPos(int x, int y) {
        return this.isValidPos(new Vector2i(x, y));
    }

    public boolean isValidPos(Vector2i pos) {
        return this.nodes.containsKey(pos);
    }

    public Optional<GridNodeDefinition> getNode(int x, int y) {
        return this.getNode(new Vector2i(x, y));
    }

    public Optional<GridNodeDefinition> getNode(Vector2i pos) {
        return this.isValidPos(pos) ? Optional.ofNullable(this.nodes.get(pos)) : Optional.empty();
    }

    protected record PlacedNode(Vector2i pos, GridNodeDefinition definition) {
        public static Codec<PlacedNode> codec() {
            return RecordCodecBuilder.create(instance -> instance.group((App)CodecUtils.VECTOR2I.fieldOf("pos").forGetter(PlacedNode::pos), (App)GridNodeDefinition.codec().fieldOf("definition").forGetter(PlacedNode::definition)).apply((Applicative)instance, PlacedNode::new));
        }

        public static StreamCodec<FriendlyByteBuf, PlacedNode> streamCodec() {
            return StreamCodec.composite(StreamCodecUtils.VECTOR2I, PlacedNode::pos, GridNodeDefinition.streamCodec(), PlacedNode::definition, PlacedNode::new);
        }
    }

    public static class Builder {
        protected final ResourceLocation key;
        protected final HolderLookup.Provider registries;
        protected final Map<Vector2i, GridNodeDefinition> nodes = new HashMap<Vector2i, GridNodeDefinition>();
        protected ResourceKey<BookLanguage> language;
        protected Vector2i startPos;

        protected Builder(ResourceLocation key, HolderLookup.Provider registries) {
            this.key = (ResourceLocation)Preconditions.checkNotNull((Object)key);
            this.registries = registries;
        }

        public static Builder grid(String name, HolderLookup.Provider registries) {
            return new Builder(ResourceUtils.loc(name), registries);
        }

        public static Builder grid(ResourceLocation key, HolderLookup.Provider registries) {
            return new Builder(key, registries);
        }

        public Builder language(ResourceKey<BookLanguage> language) {
            this.language = (ResourceKey)Preconditions.checkNotNull(language);
            return this;
        }

        public Builder startPos(int x, int y) {
            this.startPos = new Vector2i(x, y);
            return this;
        }

        public Builder node(int x, int y, GridNodeDefinition def) {
            this.nodes.put(new Vector2i(x, y), (GridNodeDefinition)Preconditions.checkNotNull((Object)def));
            return this;
        }

        private void validate() {
            if (this.language == null) {
                throw new IllegalStateException("No language for linguistics grid " + this.key.toString());
            }
            if (this.startPos == null) {
                throw new IllegalStateException("No start position for linguistics grid " + this.key.toString());
            }
            if (this.startPos.x() < 0 || this.startPos.x() > 7) {
                throw new IllegalStateException("Out of bounds start position X-coordinate for linguistics grid " + this.key.toString() + "; must be between 0 and 7");
            }
            if (this.startPos.y() < 0 || this.startPos.y() > 7) {
                throw new IllegalStateException("Out of bounds start position Y-coordinate for linguistics grid " + this.key.toString() + "; must be between 0 and 7");
            }
            if (!this.nodes.keySet().contains(this.startPos)) {
                throw new IllegalStateException("Start position not among defined nodes for linguistics grid " + this.key.toString());
            }
            int total = 0;
            for (GridNodeDefinition def : this.nodes.values()) {
                IReward iReward = def.getReward();
                if (!(iReward instanceof ComprehensionReward)) continue;
                ComprehensionReward compReward = (ComprehensionReward)iReward;
                total += compReward.getPoints();
            }
            int expected = ((BookLanguage)this.registries.lookupOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getOrThrow(this.language).value()).complexity();
            if (total != expected) {
                throw new IllegalStateException("Comprehension mismatch for linguistics grid " + this.key.toString() + "; expected " + expected + ", got " + total);
            }
        }

        public GridDefinition build() {
            this.validate();
            return new GridDefinition(this.key, this.language, this.startPos, this.nodes);
        }
    }
}

