/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public enum ScribeTableMode implements StringRepresentable
{
    STUDY_VOCABULARY("study_vocabulary"),
    GAIN_COMPREHENSION("gain_comprehension"),
    TRANSCRIBE_WORKS("transcribe_works");

    private final String tag;
    private final Component tooltip;
    private final ResourceLocation iconSprite;

    private ScribeTableMode(String tag) {
        this.tag = tag;
        this.tooltip = Component.translatable((String)("tooltip.primalmagick.scribe_table.mode." + tag));
        this.iconSprite = ResourceUtils.loc("scribe_table/" + tag);
    }

    public String getTag() {
        return this.tag;
    }

    public Component getTooltip() {
        return this.tooltip;
    }

    public ResourceLocation getIconSprite() {
        return this.iconSprite;
    }

    public String getSerializedName() {
        return this.tag;
    }

    @Nullable
    public static ScribeTableMode fromName(@Nullable String name) {
        for (ScribeTableMode mode : ScribeTableMode.values()) {
            if (!mode.getSerializedName().equals(name)) continue;
            return mode;
        }
        return null;
    }
}

