/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookLanguagesPM;
import com.verdantartifice.primalmagick.common.books.ScribeTableMode;
import com.verdantartifice.primalmagick.common.books.grids.GridDefinition;
import com.verdantartifice.primalmagick.common.books.grids.PlayerGrid;
import com.verdantartifice.primalmagick.common.capabilities.IPlayerLinguistics;
import com.verdantartifice.primalmagick.common.stats.StatsManager;
import com.verdantartifice.primalmagick.common.stats.StatsPM;
import com.verdantartifice.primalmagick.common.tags.BookLanguageTagsPM;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.Vector2i;

public class LinguisticsManager {
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();
    protected static final Map<ResourceLocation, GridDefinition> GRID_DEFINITIONS = new HashMap<ResourceLocation, GridDefinition>();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.getUUID());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.getUUID());
        }
    }

    public static boolean isLanguageKnown(@Nullable Player player, @Nullable Holder<BookLanguage> language) {
        if (language == null) {
            return false;
        }
        if (language.is(BookLanguagesPM.DEFAULT)) {
            return true;
        }
        return Services.CAPABILITIES.linguistics(player).map(linguistics -> linguistics.isLanguageKnown(((BookLanguage)language.value()).languageId())).orElse(false);
    }

    public static void markRead(@Nullable Player player, @Nullable Holder<BookDefinition> book, @Nullable Holder<BookLanguage> language) {
        if (player != null && book != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                if (linguistics.markRead(((BookDefinition)book.value()).bookId(), ((BookLanguage)language.value()).languageId()) && language.is(BookLanguageTagsPM.LINGUISTICS_UNLOCK)) {
                    StatsManager.incrementValue(player, StatsPM.ANCIENT_BOOKS_READ);
                }
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static int getComprehension(@Nullable Player player, @Nullable Holder<BookLanguage> language) {
        MutableInt retVal = new MutableInt(0);
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getComprehension(((BookLanguage)language.value()).languageId())));
        }
        return retVal.intValue();
    }

    public static void setComprehension(@Nullable Player player, @Nullable Holder<BookLanguage> language, int comprehension) {
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                int finalValue = Mth.clamp((int)comprehension, (int)0, (int)((BookLanguage)language.value()).complexity());
                linguistics.setComprehension(((BookLanguage)language.value()).languageId(), finalValue);
                LinguisticsManager.scheduleSync(player);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (language.unwrapKey().isPresent()) {
                        CriteriaTriggersPM.LINGUISTICS_COMPREHENSION.get().trigger(serverPlayer, (ResourceKey<BookLanguage>)((ResourceKey)language.unwrapKey().get()), finalValue);
                    }
                }
            });
        }
    }

    public static void incrementComprehension(@Nullable Player player, @Nullable Holder<BookLanguage> language) {
        LinguisticsManager.incrementComprehension(player, language, 1);
    }

    public static void incrementComprehension(@Nullable Player player, @Nullable Holder<BookLanguage> language, int delta) {
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                int finalValue = Mth.clamp((int)(linguistics.getComprehension(((BookLanguage)language.value()).languageId()) + delta), (int)0, (int)((BookLanguage)language.value()).complexity());
                linguistics.setComprehension(((BookLanguage)language.value()).languageId(), finalValue);
                LinguisticsManager.scheduleSync(player);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (language.unwrapKey().isPresent()) {
                        CriteriaTriggersPM.LINGUISTICS_COMPREHENSION.get().trigger(serverPlayer, (ResourceKey<BookLanguage>)((ResourceKey)language.unwrapKey().get()), finalValue);
                    }
                }
            });
        }
    }

    public static int getVocabulary(@Nullable Player player, @Nullable Holder<BookLanguage> language) {
        MutableInt retVal = new MutableInt(0);
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getVocabulary(((BookLanguage)language.value()).languageId())));
        }
        return retVal.intValue();
    }

    public static void setVocabulary(@Nullable Player player, @Nullable Holder<BookLanguage> language, int vocabulary) {
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                linguistics.setVocabulary(((BookLanguage)language.value()).languageId(), Math.max(0, vocabulary));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static void incrementVocabulary(@Nullable Player player, @Nullable Holder<BookLanguage> language) {
        LinguisticsManager.incrementVocabulary(player, language, 1);
    }

    public static void incrementVocabulary(@Nullable Player player, @Nullable Holder<BookLanguage> language, int delta) {
        if (player != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                linguistics.setVocabulary(((BookLanguage)language.value()).languageId(), Math.max(0, linguistics.getVocabulary(((BookLanguage)language.value()).languageId()) + delta));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static int getTimesStudied(@Nullable Player player, @Nullable Holder<BookDefinition> book, @Nullable Holder<BookLanguage> language) {
        MutableInt retVal = new MutableInt(0);
        if (player != null && book != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getTimesStudied(((BookDefinition)book.value()).bookId(), ((BookLanguage)language.value()).languageId())));
        }
        return retVal.intValue();
    }

    public static void setTimesStudied(@Nullable Player player, @Nullable Holder<BookDefinition> book, @Nullable Holder<BookLanguage> language, int studyCount) {
        if (player != null && book != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                linguistics.setTimesStudied(((BookDefinition)book.value()).bookId(), ((BookLanguage)language.value()).languageId(), Math.max(0, studyCount));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static void incrementTimesStudied(@Nullable Player player, @Nullable Holder<BookDefinition> book, @Nullable Holder<BookLanguage> language) {
        LinguisticsManager.incrementTimesStudied(player, book, language, 1);
    }

    public static void incrementTimesStudied(@Nullable Player player, @Nullable Holder<BookDefinition> book, @Nullable Holder<BookLanguage> language, int delta) {
        if (player != null && book != null && language != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                linguistics.setTimesStudied(((BookDefinition)book.value()).bookId(), ((BookLanguage)language.value()).languageId(), Math.max(0, linguistics.getTimesStudied(((BookDefinition)book.value()).bookId(), ((BookLanguage)language.value()).languageId()) + delta));
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static ScribeTableMode getScribeTableMode(@Nullable Player player) {
        return Services.CAPABILITIES.linguistics(player).map(IPlayerLinguistics::getScribeTableMode).orElse(ScribeTableMode.STUDY_VOCABULARY);
    }

    public static void setScribeTableMode(@Nullable Player player, @Nullable ScribeTableMode mode) {
        if (player != null && mode != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> {
                linguistics.setScribeTableMode(mode);
                LinguisticsManager.scheduleSync(player);
            });
        }
    }

    public static void clearAllGridDefinitions() {
        GRID_DEFINITIONS.clear();
    }

    public static Map<ResourceLocation, GridDefinition> getAllGridDefinitions() {
        return Collections.unmodifiableMap(GRID_DEFINITIONS);
    }

    public static boolean registerGridDefinition(ResourceLocation definitionKey, GridDefinition gridDefinition) {
        if (GRID_DEFINITIONS.containsKey(definitionKey)) {
            return false;
        }
        GRID_DEFINITIONS.put(definitionKey, gridDefinition);
        return true;
    }

    @Nullable
    protected static GridDefinition getGridDefinition(@Nonnull ResourceLocation gridKey) {
        return GRID_DEFINITIONS.get(gridKey);
    }

    protected static Set<Vector2i> getUnlockedGridNodes(@Nullable Player player, @Nullable ResourceLocation gridKey) {
        MutableObject retVal = new MutableObject(Collections.emptySet());
        if (player != null && gridKey != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getUnlockedNodes(gridKey)));
        }
        return (Set)retVal.getValue();
    }

    protected static long getGridLastModified(@Nullable Player player, @Nullable ResourceLocation gridKey) {
        MutableLong retVal = new MutableLong(0L);
        if (player != null && gridKey != null) {
            Services.CAPABILITIES.linguistics(player).ifPresent(linguistics -> retVal.setValue(linguistics.getGridLastModified(gridKey)));
        }
        return retVal.getValue();
    }

    @Nullable
    public static PlayerGrid getPlayerGrid(@Nonnull Player player, @Nonnull ResourceLocation gridKey) {
        GridDefinition gridDef = LinguisticsManager.getGridDefinition(gridKey);
        return gridDef == null ? null : new PlayerGrid(player, gridDef, LinguisticsManager.getUnlockedGridNodes(player, gridKey), LinguisticsManager.getGridLastModified(player, gridKey));
    }

    public static int getTotalRemainingVocabularyRequired(@Nonnull Player player, @Nonnull Holder<BookLanguage> language) {
        return GRID_DEFINITIONS.entrySet().stream().filter(e -> language.is(((GridDefinition)e.getValue()).getLanguage())).map(e -> LinguisticsManager.getPlayerGrid(player, (ResourceLocation)e.getKey())).flatMap(pg -> pg.getLockedNodes()).mapToInt(n -> n.getVocabularyCost()).sum();
    }
}

