/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LexiconManager {
    public static final ResourceLocation LOREM_IPSUM = ResourceUtils.loc("lorem_ipsum");
    protected static final Map<ResourceLocation, Lexicon> REGISTRY = new HashMap<ResourceLocation, Lexicon>();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void setLexicon(ResourceLocation id, Lexicon lexicon) {
        if (REGISTRY.containsKey(id)) {
            LOGGER.info("Replacing lexicon for {} with {} entries", (Object)id.toString(), (Object)lexicon.size());
        } else {
            LOGGER.info("Registered {} lexicon with {} entries", (Object)id.toString(), (Object)lexicon.size());
        }
        REGISTRY.put(id, lexicon);
    }

    public static Optional<Lexicon> getLexicon(ResourceLocation id) {
        return Optional.ofNullable(REGISTRY.get(id));
    }

    public static Collection<Lexicon> getAllLexicons() {
        return Collections.unmodifiableCollection(REGISTRY.values());
    }
}

