/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.util.Mth;

public class Lexicon {
    protected static final Comparator<Entry> BY_HASH_CODE = Comparator.comparingInt(Entry::hashCode);
    protected static final Comparator<Entry> BY_MOST_FREQUENT = Comparator.comparingInt(Entry::getCount).reversed().thenComparing(BY_HASH_CODE);
    protected final Map<String, Entry> entries = new HashMap<String, Entry>();
    private Supplier<List<String>> cachedMostFrequent;
    private Function<Integer, List<String>> cachedOfLength;

    public Lexicon() {
        this(new String[0]);
    }

    public Lexicon(String ... words) {
        this(List.of(words));
    }

    public Lexicon(Collection<String> words) {
        this.addWords(words);
        this.invalidate();
    }

    public static Lexicon parse(@Nonnull JsonObject json) throws Exception {
        return new Lexicon(json.get("words").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toList());
    }

    public void clear() {
        this.entries.clear();
        this.invalidate();
    }

    public void invalidate() {
        this.cachedMostFrequent = Suppliers.memoize(this::getWordsByMostFrequentInner);
        this.cachedOfLength = Util.memoize(this::getWordsOfLengthInner);
    }

    public int size() {
        return this.entries.size();
    }

    public void addWord(String word) {
        this.addWordInner(word);
        this.invalidate();
    }

    public void addWords(Collection<String> words) {
        words.forEach(this::addWordInner);
        this.invalidate();
    }

    private void addWordInner(String word) {
        String toAdd = word.toLowerCase();
        if (this.entries.containsKey(toAdd)) {
            this.entries.get(toAdd).incrementCount();
        } else {
            this.entries.put(toAdd, new Entry(toAdd));
        }
    }

    public List<String> getWordsByMostFrequent() {
        return this.cachedMostFrequent.get();
    }

    private List<String> getWordsByMostFrequentInner() {
        return this.entries.values().stream().sorted(BY_MOST_FREQUENT).map(Entry::getWord).toList();
    }

    public List<String> getWordsOfLength(int length) {
        return this.cachedOfLength.apply(length);
    }

    private List<String> getWordsOfLengthInner(int length) {
        return this.entries.values().stream().filter(entry -> entry.getLength() == length).sorted(BY_HASH_CODE).map(Entry::getWord).toList();
    }

    public String getReplacementWord(String original) {
        List<String> candidates = this.getWordsOfLength(original.length());
        if (candidates.isEmpty()) {
            return original;
        }
        return candidates.get(Math.abs(original.hashCode()) % candidates.size());
    }

    public boolean isWordTranslated(String word, int comprehension, int complexity) {
        if (complexity == 0) {
            return true;
        }
        if (complexity < 0) {
            return false;
        }
        return this.getTranslatedWords(comprehension, complexity).contains(word.toLowerCase());
    }

    protected List<String> getTranslatedWords(int comprehension, int complexity) {
        List<String> words = this.getWordsByMostFrequent();
        if (complexity == 0) {
            return words;
        }
        if (complexity < 0) {
            return List.of();
        }
        double progress = Mth.clamp((double)((double)comprehension / (double)complexity), (double)0.0, (double)1.0);
        int wordCount = Mth.ceil((double)(progress * (double)words.size()));
        return words.subList(0, wordCount);
    }

    protected static class Entry {
        private final String word;
        private int count;

        public Entry(String word) {
            this.word = word;
            this.count = 1;
        }

        public String getWord() {
            return this.word;
        }

        public int getLength() {
            return this.word.length();
        }

        public int getCount() {
            return this.count;
        }

        public void incrementCount() {
            ++this.count;
        }

        public int hashCode() {
            return Objects.hash(this.word);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            return Objects.equals(this.word, other.word);
        }

        public String toString() {
            return "Entry [word=" + this.word + ", count=" + this.count + "]";
        }
    }
}

