/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.blocks.BlocksPM;
import com.verdantartifice.primalmagick.common.books.Culture;
import com.verdantartifice.primalmagick.common.loot.LootTablesPM;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;

public class CulturesPM {
    public static final ResourceKey<Culture> GLOBAL = CulturesPM.create("global");
    public static final ResourceKey<Culture> EARTH = CulturesPM.create("earth");
    public static final ResourceKey<Culture> SEA = CulturesPM.create("sea");
    public static final ResourceKey<Culture> SKY = CulturesPM.create("sky");
    public static final ResourceKey<Culture> SUN = CulturesPM.create("sun");
    public static final ResourceKey<Culture> MOON = CulturesPM.create("moon");
    public static final ResourceKey<Culture> FORBIDDEN = CulturesPM.create("forbidden");

    public static ResourceKey<Culture> create(String name) {
        return ResourceKey.create(RegistryKeysPM.CULTURES, (ResourceLocation)ResourceUtils.loc(name));
    }

    public static void bootstrap(BootstrapContext<Culture> context) {
        context.register(EARTH, (Object)new Culture(ResourceUtils.loc("earth"), LootTablesPM.LIBRARY_EARTH, LootTablesPM.LIBRARY_WELCOME, LootTablesPM.LIBRARY_HIDDEN, BlocksPM.STAINED_SKYGLASS_GREEN.get().defaultBlockState()));
        context.register(SEA, (Object)new Culture(ResourceUtils.loc("sea"), LootTablesPM.LIBRARY_SEA, LootTablesPM.LIBRARY_WELCOME, LootTablesPM.LIBRARY_HIDDEN, BlocksPM.STAINED_SKYGLASS_BLUE.get().defaultBlockState()));
        context.register(SKY, (Object)new Culture(ResourceUtils.loc("sky"), LootTablesPM.LIBRARY_SKY, LootTablesPM.LIBRARY_WELCOME, LootTablesPM.LIBRARY_HIDDEN, BlocksPM.STAINED_SKYGLASS_LIGHT_BLUE.get().defaultBlockState()));
        context.register(SUN, (Object)new Culture(ResourceUtils.loc("sun"), LootTablesPM.LIBRARY_SUN, LootTablesPM.LIBRARY_WELCOME, LootTablesPM.LIBRARY_HIDDEN, BlocksPM.STAINED_SKYGLASS_YELLOW.get().defaultBlockState()));
        context.register(MOON, (Object)new Culture(ResourceUtils.loc("moon"), LootTablesPM.LIBRARY_MOON, LootTablesPM.LIBRARY_WELCOME, LootTablesPM.LIBRARY_HIDDEN, BlocksPM.STAINED_SKYGLASS_LIGHT_GRAY.get().defaultBlockState()));
        context.register(FORBIDDEN, (Object)new Culture(ResourceUtils.loc("forbidden"), LootTablesPM.LIBRARY_FORBIDDEN, LootTablesPM.LIBRARY_WARNING, (ResourceKey<LootTable>)BuiltInLootTables.EMPTY, BlocksPM.STAINED_SKYGLASS_RED.get().defaultBlockState()));
    }
}

