/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;

public record BookView(Either<Holder<BookDefinition>, Holder<Enchantment>> bookDef, Holder<BookLanguage> language, int comprehension) {
    public static final Codec<BookView> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.either(BookDefinition.HOLDER_CODEC, (Codec)Enchantment.CODEC).fieldOf("bookDef").forGetter(BookView::bookDef), (App)BookLanguage.HOLDER_CODEC.fieldOf("language").forGetter(BookView::language), (App)Codec.INT.fieldOf("comprehension").forGetter(BookView::comprehension)).apply((Applicative)instance, BookView::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BookView> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.either(BookDefinition.STREAM_CODEC, (StreamCodec)Enchantment.STREAM_CODEC), BookView::bookDef, BookLanguage.STREAM_CODEC, BookView::language, (StreamCodec)ByteBufCodecs.VAR_INT, BookView::comprehension, BookView::new);

    public BookView withComprehension(int newComprehension) {
        return new BookView(this.bookDef, this.language, newComprehension);
    }

    public ResourceKey<?> unwrapBookKey() {
        return (ResourceKey)this.bookDef.map(bookHolder -> (ResourceKey)bookHolder.unwrapKey().get(), enchHolder -> (ResourceKey)enchHolder.unwrapKey().get());
    }
}

