/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.registries.RegistryKeysPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class BookLanguagesPM {
    public static final ResourceKey<BookLanguage> DEFAULT = BookLanguagesPM.create("default");
    public static final ResourceKey<BookLanguage> GALACTIC = BookLanguagesPM.create("galactic");
    public static final ResourceKey<BookLanguage> ILLAGER = BookLanguagesPM.create("illager");
    public static final ResourceKey<BookLanguage> BABELTONGUE = BookLanguagesPM.create("babeltongue");
    public static final ResourceKey<BookLanguage> EARTH = BookLanguagesPM.create("earth");
    public static final ResourceKey<BookLanguage> SEA = BookLanguagesPM.create("sea");
    public static final ResourceKey<BookLanguage> SKY = BookLanguagesPM.create("sky");
    public static final ResourceKey<BookLanguage> SUN = BookLanguagesPM.create("sun");
    public static final ResourceKey<BookLanguage> MOON = BookLanguagesPM.create("moon");
    public static final ResourceKey<BookLanguage> TRADE = BookLanguagesPM.create("trade");
    public static final ResourceKey<BookLanguage> FORBIDDEN = BookLanguagesPM.create("forbidden");
    public static final ResourceKey<BookLanguage> HALLOWED = BookLanguagesPM.create("hallowed");

    public static ResourceKey<BookLanguage> create(String name) {
        return ResourceKey.create(RegistryKeysPM.BOOK_LANGUAGES, (ResourceLocation)ResourceUtils.loc(name));
    }

    public static void bootstrap(BootstrapContext<BookLanguage> context) {
        context.register(DEFAULT, (Object)new BookLanguage(ResourceUtils.loc("default"), Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"default")), 0, false));
        context.register(GALACTIC, (Object)new BookLanguage(ResourceUtils.loc("galactic"), Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"alt")), -1, false));
        context.register(ILLAGER, (Object)new BookLanguage(ResourceUtils.loc("illager"), Style.EMPTY.withFont(ResourceLocation.withDefaultNamespace((String)"illageralt")), -1, false));
        context.register(BABELTONGUE, (Object)new BookLanguage(ResourceUtils.loc("babeltongue"), Style.EMPTY.withObfuscated(Boolean.valueOf(true)), 60, true));
        context.register(EARTH, (Object)new BookLanguage(ResourceUtils.loc("earth"), Style.EMPTY.withFont(ResourceUtils.loc("earth")), 60, false));
        context.register(SEA, (Object)new BookLanguage(ResourceUtils.loc("sea"), Style.EMPTY.withFont(ResourceUtils.loc("sea")), 60, false));
        context.register(SKY, (Object)new BookLanguage(ResourceUtils.loc("sky"), Style.EMPTY.withFont(ResourceUtils.loc("sky")), 60, false));
        context.register(SUN, (Object)new BookLanguage(ResourceUtils.loc("sun"), Style.EMPTY.withFont(ResourceUtils.loc("sun")), 60, false));
        context.register(MOON, (Object)new BookLanguage(ResourceUtils.loc("moon"), Style.EMPTY.withFont(ResourceUtils.loc("moon")), 60, false));
        context.register(TRADE, (Object)new BookLanguage(ResourceUtils.loc("trade"), Style.EMPTY.withFont(ResourceUtils.loc("trade")), 60, false));
        context.register(FORBIDDEN, (Object)new BookLanguage(ResourceUtils.loc("forbidden"), Style.EMPTY.withFont(ResourceUtils.loc("forbidden")), 60, false));
        context.register(HALLOWED, (Object)new BookLanguage(ResourceUtils.loc("hallowed"), Style.EMPTY.withFont(ResourceUtils.loc("hallowed")), 60, false));
    }

    public static Optional<Holder.Reference<BookLanguage>> getLanguage(ResourceKey<BookLanguage> langKey, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getHolder(langKey);
    }

    public static Holder.Reference<BookLanguage> getLanguageOrDefault(ResourceKey<BookLanguage> langKey, RegistryAccess registryAccess, ResourceKey<BookLanguage> defaultLang) {
        Registry registry = registryAccess.registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES);
        return registry.getHolder(langKey).orElse(registry.getHolderOrThrow(defaultLang));
    }

    public static Holder.Reference<BookLanguage> getLanguageOrThrow(ResourceKey<BookLanguage> langKey, RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(RegistryKeysPM.BOOK_LANGUAGES).getHolderOrThrow(langKey);
    }
}

