/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.books;

import com.verdantartifice.primalmagick.client.books.ClientBookHelper;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.BookView;
import com.verdantartifice.primalmagick.common.books.Lexicon;
import com.verdantartifice.primalmagick.common.books.LexiconManager;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringDecomposer;

public class BookHelper {
    public static final Pattern WORD_BOUNDARY = Pattern.compile("\\b");
    public static final Pattern SEPARATOR_ONLY = Pattern.compile("^[\\p{P} \\n]+$");
    public static final Style BASE_TEXT_STYLE = Style.EMPTY;
    private static Function<BookView, Component> memoizedTitleText = Util.memoize(BookHelper::getTitleTextInner);
    private static BiFunction<BookView, Component, Component> memoizedAuthorText = Util.memoize(BookHelper::getAuthorTextInner);

    public static void invalidate() {
        memoizedTitleText = Util.memoize(BookHelper::getTitleTextInner);
        memoizedAuthorText = Util.memoize(BookHelper::getAuthorTextInner);
    }

    public static String getTitleTranslationKey(BookView view) {
        return (String)view.bookDef().map(bookHolder -> {
            ResourceLocation bookLoc = ((BookDefinition)bookHolder.value()).bookId();
            return String.join((CharSequence)".", "written_book", bookLoc.getNamespace(), bookLoc.getPath(), "title");
        }, enchHolder -> "tooltip.primalmagick.question_marks");
    }

    public static Component getTitleText(BookView view) {
        return memoizedTitleText.apply(view);
    }

    private static Component getTitleTextInner(BookView view) {
        MutableComponent retVal = Component.empty();
        String titleTranslationKey = BookHelper.getTitleTranslationKey(view);
        Lexicon langLex = LexiconManager.getLexicon(((ResourceKey)view.language().unwrapKey().get()).location()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Stream.of(WORD_BOUNDARY.split(StringDecomposer.getPlainText((FormattedText)Component.translatable((String)titleTranslationKey)))).forEach(word -> {
            if (SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else if (((BookLanguage)view.language().value()).autoTranslate()) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else if (((BookLanguage)view.language().value()).isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), ((BookLanguage)view.language().value()).complexity())) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else {
                retVal.append((Component)Component.literal((String)loremLex.getReplacementWord((String)word)).withStyle(((BookLanguage)view.language().value()).style()));
            }
        });
        return retVal;
    }

    public static Component getAuthorText(BookView view, Component unencodedText) {
        return memoizedAuthorText.apply(view, unencodedText);
    }

    private static Component getAuthorTextInner(BookView view, Component unencodedText) {
        MutableComponent retVal = Component.empty();
        Lexicon langLex = LexiconManager.getLexicon(((ResourceKey)view.language().unwrapKey().get()).location()).orElseThrow();
        Lexicon loremLex = LexiconManager.getLexicon(LexiconManager.LOREM_IPSUM).orElseThrow();
        Stream.of(WORD_BOUNDARY.split(StringDecomposer.getPlainText((FormattedText)unencodedText))).forEach(word -> {
            if (SEPARATOR_ONLY.matcher((CharSequence)word).matches()) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else if (((BookLanguage)view.language().value()).autoTranslate()) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else if (((BookLanguage)view.language().value()).isTranslatable() && langLex.isWordTranslated((String)word, view.comprehension(), ((BookLanguage)view.language().value()).complexity())) {
                retVal.append((Component)Component.literal((String)word).withStyle(BASE_TEXT_STYLE));
            } else {
                retVal.append((Component)Component.literal((String)loremLex.getReplacementWord((String)word)).withStyle(((BookLanguage)view.language().value()).style()));
            }
        });
        return retVal;
    }

    public static double getBookComprehension(BookView view) {
        return Services.PLATFORM.isClientDist() ? ClientBookHelper.getBookComprehension(view) : 0.0;
    }
}

