/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blockstates.properties;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;

public enum TimePhase implements StringRepresentable
{
    FULL("full", 10),
    WAXING("waxing", 5),
    WANING("waning", 0),
    FADED("faded", 0);

    private final String name;
    private final int light;

    private TimePhase(String name, int light) {
        this.name = name;
        this.light = light;
    }

    public static TimePhase getSunPhase(LevelAccessor world) {
        float angle = world.getTimeOfDay(1.0f);
        if (angle < 0.1875f) {
            return FULL;
        }
        if (angle < 0.25f) {
            return WAXING;
        }
        if (angle < 0.3125f) {
            return WANING;
        }
        if (angle < 0.6875f) {
            return FADED;
        }
        if (angle < 0.75f) {
            return WANING;
        }
        if (angle < 0.8125f) {
            return WAXING;
        }
        return FULL;
    }

    public static TimePhase getMoonPhase(LevelAccessor world) {
        float angle = world.getTimeOfDay(1.0f);
        if (angle < 0.1875f) {
            return FADED;
        }
        if (angle < 0.25f) {
            return WANING;
        }
        if (angle < 0.3125f) {
            return WAXING;
        }
        if (angle < 0.6875f) {
            return FULL;
        }
        if (angle < 0.75f) {
            return WAXING;
        }
        if (angle < 0.8125f) {
            return WANING;
        }
        return FADED;
    }

    public String toString() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public int getLightLevel() {
        return this.light;
    }
}

