/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.trees;

import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class StrippableLogBlock
extends RotatedPillarBlock {
    protected final Block strippedVersion;

    public StrippableLogBlock(Block stripped, BlockBehaviour.Properties properties) {
        super(properties);
        this.strippedVersion = stripped;
    }

    protected BlockState getDefaultStrippedState(BlockState originalState) {
        return (BlockState)this.strippedVersion.defaultBlockState().setValue((Property)RotatedPillarBlock.AXIS, (Comparable)((Direction.Axis)originalState.getValue((Property)RotatedPillarBlock.AXIS)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (this.strippedVersion != null && player != null && Services.ITEM_ABILITIES.canAxeStrip(stack)) {
            worldIn.playSound(player, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!worldIn.isClientSide) {
                worldIn.setBlock(pos, this.getDefaultStrippedState(state), 11);
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)handIn));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

