/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.trees;

import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractPhasingSlabBlock
extends SlabBlock {
    public static final EnumProperty<TimePhase> PHASE = EnumProperty.create((String)"phase", TimePhase.class);

    public AbstractPhasingSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PHASE, (Comparable)((Object)TimePhase.FULL)));
    }

    protected abstract TimePhase getCurrentPhase(LevelAccessor var1);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PHASE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        TimePhase phase = this.getCurrentPhase((LevelAccessor)context.getLevel());
        return (BlockState)super.getStateForPlacement(context).setValue(PHASE, (Comparable)((Object)phase));
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, worldIn, pos, random);
        TimePhase newPhase = this.getCurrentPhase((LevelAccessor)worldIn);
        if (newPhase != state.getValue(PHASE)) {
            worldIn.setBlock(pos, (BlockState)state.setValue(PHASE, (Comparable)((Object)newPhase)), 3);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState state = super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        TimePhase newPhase = this.getCurrentPhase(worldIn);
        if (newPhase != state.getValue(PHASE)) {
            state = (BlockState)state.setValue(PHASE, (Comparable)((Object)newPhase));
        }
        return state;
    }
}

