/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.trees;

import com.verdantartifice.primalmagick.common.blockstates.properties.TimePhase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class AbstractPhasingLeavesBlock
extends Block {
    public static final EnumProperty<TimePhase> PHASE = EnumProperty.create((String)"phase", TimePhase.class);
    public static final IntegerProperty DISTANCE = BlockStateProperties.DISTANCE;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;

    public AbstractPhasingLeavesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(PHASE, (Comparable)((Object)TimePhase.FULL))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public abstract TimePhase getCurrentPhase(LevelAccessor var1);

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DISTANCE, PERSISTENT, PHASE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        TimePhase phase = this.getCurrentPhase((LevelAccessor)context.getLevel());
        return AbstractPhasingLeavesBlock.updateDistance((BlockState)((BlockState)this.defaultBlockState().setValue(PHASE, (Comparable)((Object)phase))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) == 7 && (Boolean)state.getValue((Property)PERSISTENT) == false;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        TimePhase newPhase;
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && (Integer)state.getValue((Property)DISTANCE) == 7) {
            AbstractPhasingLeavesBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
        if ((newPhase = this.getCurrentPhase((LevelAccessor)worldIn)) != state.getValue(PHASE)) {
            worldIn.setBlock(pos, (BlockState)state.setValue(PHASE, (Comparable)((Object)newPhase)), 3);
        }
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        worldIn.setBlock(pos, AbstractPhasingLeavesBlock.updateDistance(state, (LevelAccessor)worldIn, pos), 3);
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        TimePhase newPhase;
        int i = AbstractPhasingLeavesBlock.getDistance(facingState) + 1;
        if (i != 1 || (Integer)stateIn.getValue((Property)DISTANCE) != i) {
            worldIn.scheduleTick(currentPos, (Block)this, 1);
        }
        if ((newPhase = this.getCurrentPhase(worldIn)) != stateIn.getValue(PHASE)) {
            stateIn = (BlockState)stateIn.setValue(PHASE, (Comparable)((Object)newPhase));
        }
        return stateIn;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor world, BlockPos pos) {
        int dist = 7;
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            mbp.set((Vec3i)pos).move(dir);
            dist = Math.min(dist, AbstractPhasingLeavesBlock.getDistance(world.getBlockState((BlockPos)mbp)) + 1);
            if (dist == 1) break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(dist));
    }

    private static int getDistance(BlockState neighbor) {
        if (neighbor.is(BlockTags.LOGS)) {
            return 0;
        }
        if (neighbor.getBlock() instanceof AbstractPhasingLeavesBlock || neighbor.getBlock() instanceof LeavesBlock) {
            return (Integer)neighbor.getValue((Property)DISTANCE);
        }
        return 7;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        BlockPos blockpos;
        BlockState blockstate;
        if (!(!worldIn.isRainingAt(pos.above()) || rand.nextInt(15) != 1 || (blockstate = worldIn.getBlockState(blockpos = pos.below())).canOcclude() && blockstate.isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP))) {
            double x = (double)pos.getX() + rand.nextDouble();
            double y = (double)pos.getY() - 0.05;
            double z = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.DRIPPING_WATER, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected static Boolean allowsSpawnOnLeaves(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
        return entity == EntityType.OCELOT || entity == EntityType.PARROT;
    }
}

