/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.blockstates.properties.SaltSide;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class SaltTrailBlock
extends Block
implements ISaltPowered {
    public static final EnumProperty<SaltSide> NORTH = EnumProperty.create((String)"north", SaltSide.class);
    public static final EnumProperty<SaltSide> EAST = EnumProperty.create((String)"east", SaltSide.class);
    public static final EnumProperty<SaltSide> SOUTH = EnumProperty.create((String)"south", SaltSide.class);
    public static final EnumProperty<SaltSide> WEST = EnumProperty.create((String)"west", SaltSide.class);
    public static final IntegerProperty POWER = IntegerProperty.create((String)"salt_power", (int)0, (int)15);
    public static final Map<Direction, EnumProperty<SaltSide>> FACING_PROPERTY_MAP = new EnumMap<Direction, EnumProperty<SaltSide>>((Map<Direction, EnumProperty<SaltSide>>)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};
    protected boolean canProvidePower = true;
    protected final Set<BlockPos> blocksNeedingUpdate = new HashSet<BlockPos>();

    public SaltTrailBlock() {
        super(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).noCollission().strength(0.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(NORTH, (Comparable)((Object)SaltSide.NONE))).setValue(EAST, (Comparable)((Object)SaltSide.NONE))).setValue(SOUTH, (Comparable)((Object)SaltSide.NONE))).setValue(WEST, (Comparable)((Object)SaltSide.NONE))).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected int getAABBIndex(BlockState state) {
        boolean wConnected;
        int index = 0;
        boolean nConnected = state.getValue(NORTH) != SaltSide.NONE;
        boolean eConnected = state.getValue(EAST) != SaltSide.NONE;
        boolean sConnected = state.getValue(SOUTH) != SaltSide.NONE;
        boolean bl = wConnected = state.getValue(WEST) != SaltSide.NONE;
        if (nConnected || sConnected && !nConnected && !eConnected && !wConnected) {
            index |= 1 << Direction.NORTH.get2DDataValue();
        }
        if (eConnected || wConnected && !nConnected && !eConnected && !sConnected) {
            index |= 1 << Direction.EAST.get2DDataValue();
        }
        if (sConnected || nConnected && !eConnected && !sConnected && !wConnected) {
            index |= 1 << Direction.SOUTH.get2DDataValue();
        }
        if (wConnected || eConnected && !nConnected && !sConnected && !wConnected) {
            index |= 1 << Direction.WEST.get2DDataValue();
        }
        return index;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[this.getAABBIndex(state)];
    }

    protected boolean canConnectTo(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return state.getBlock() instanceof ISaltPowered;
    }

    @Nonnull
    protected SaltSide getSide(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull Direction face) {
        BlockPos facePos = pos.relative(face);
        BlockState faceState = world.getBlockState(facePos);
        BlockPos upPos = pos.above();
        BlockState upState = world.getBlockState(upPos);
        if (!upState.isRedstoneConductor(world, upPos)) {
            boolean isSolid = faceState.isFaceSturdy(world, facePos, Direction.UP);
            boolean canConnectFaceUp = this.canConnectTo(world.getBlockState(facePos.above()), world, facePos.above(), null);
            if (isSolid && canConnectFaceUp) {
                if (faceState.isFaceSturdy(world, facePos, face.getOpposite())) {
                    return SaltSide.UP;
                }
                return SaltSide.SIDE;
            }
        }
        boolean canConnectToFace = this.canConnectTo(faceState, world, facePos, face);
        boolean isFaceNormal = faceState.isRedstoneConductor(world, facePos);
        boolean canConnectFaceDown = this.canConnectTo(world.getBlockState(facePos.below()), world, facePos.below(), null);
        if (!(canConnectToFace || !isFaceNormal && canConnectFaceDown)) {
            return SaltSide.NONE;
        }
        return SaltSide.SIDE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(WEST, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.WEST)))).setValue(EAST, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.EAST)))).setValue(NORTH, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.NORTH)))).setValue(SOUTH, (Comparable)((Object)this.getSide((BlockGetter)world, pos, Direction.SOUTH)));
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return (BlockState)((BlockState)((BlockState)((BlockState)stateIn.setValue(WEST, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.WEST)))).setValue(EAST, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.EAST)))).setValue(NORTH, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.NORTH)))).setValue(SOUTH, (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, Direction.SOUTH)));
        }
        return (BlockState)stateIn.setValue((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)((Object)this.getSide((BlockGetter)worldIn, currentPos, facing)));
    }

    public void updateIndirectNeighbourShapes(BlockState state, LevelAccessor world, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            SaltSide saltSide = (SaltSide)((Object)state.getValue((Property)FACING_PROPERTY_MAP.get(dir)));
            if (saltSide == SaltSide.NONE || world.getBlockState((BlockPos)mbp.set((Vec3i)pos).move(dir)).getBlock() == this) continue;
            mbp.move(Direction.DOWN);
            BlockState downState = world.getBlockState((BlockPos)mbp);
            BlockPos oppDownPos = mbp.relative(dir.getOpposite());
            BlockState newDownState = downState.updateShape(dir.getOpposite(), world.getBlockState(oppDownPos), world, (BlockPos)mbp, oppDownPos);
            SaltTrailBlock.updateOrDestroy((BlockState)downState, (BlockState)newDownState, (LevelAccessor)world, (BlockPos)mbp, (int)flags, (int)recursionLeft);
            mbp.set((Vec3i)pos).move(dir).move(Direction.UP);
            BlockState upState = world.getBlockState((BlockPos)mbp);
            BlockPos oppUpPos = mbp.relative(dir.getOpposite());
            BlockState newUpState = upState.updateShape(dir.getOpposite(), world.getBlockState(oppUpPos), world, (BlockPos)mbp, oppUpPos);
            SaltTrailBlock.updateOrDestroy((BlockState)upState, (BlockState)newUpState, (LevelAccessor)world, (BlockPos)mbp, (int)flags, (int)recursionLeft);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos downPos = pos.below();
        BlockState downState = world.getBlockState(downPos);
        return downState.isFaceSturdy((BlockGetter)world, downPos, Direction.UP);
    }

    protected int getSaltPowerFromNeighbors(Level world, BlockPos pos) {
        int maxPower = 0;
        for (Direction dir : Direction.values()) {
            int power = this.getSaltPower((BlockGetter)world, pos.relative(dir), dir);
            if (power >= 15) {
                return 15;
            }
            if (power <= maxPower) continue;
            maxPower = power;
        }
        return maxPower;
    }

    protected int maxSignal(int existingSignal, BlockState neighbor) {
        if (neighbor.getBlock() == this) {
            int power = (Integer)neighbor.getValue((Property)POWER);
            return Math.max(power, existingSignal);
        }
        return existingSignal;
    }

    protected BlockState updateOwnSaltPower(Level world, BlockPos pos, BlockState state) {
        int decrSignal;
        BlockState stateCopy = state;
        int curPower = (Integer)state.getValue((Property)POWER);
        this.canProvidePower = false;
        int neighborPower = this.getSaltPowerFromNeighbors(world, pos);
        this.canProvidePower = true;
        int signal = 0;
        if (neighborPower < 15) {
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.relative(dir);
                BlockState offsetState = world.getBlockState(offsetPos);
                signal = this.maxSignal(signal, offsetState);
                BlockPos upPos = pos.above();
                if (offsetState.isRedstoneConductor((BlockGetter)world, offsetPos) && !world.getBlockState(upPos).isRedstoneConductor((BlockGetter)world, upPos)) {
                    signal = this.maxSignal(signal, world.getBlockState(offsetPos.above()));
                    continue;
                }
                if (offsetState.isRedstoneConductor((BlockGetter)world, offsetPos)) continue;
                signal = this.maxSignal(signal, world.getBlockState(offsetPos.below()));
            }
        }
        if (neighborPower > (decrSignal = signal - 1)) {
            decrSignal = neighborPower;
        }
        if (curPower != decrSignal) {
            state = (BlockState)state.setValue((Property)POWER, (Comparable)Integer.valueOf(decrSignal));
            if (world.getBlockState(pos) == stateCopy) {
                world.setBlock(pos, state, 2);
            }
            this.blocksNeedingUpdate.add(pos);
            for (Direction dir : Direction.values()) {
                this.blocksNeedingUpdate.add(pos.relative(dir));
            }
        }
        return state;
    }

    protected BlockState updateSurroundingSaltPower(Level world, BlockPos pos, BlockState state) {
        state = this.updateOwnSaltPower(world, pos, state);
        ArrayList<BlockPos> updateList = new ArrayList<BlockPos>(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos updatePos : updateList) {
            world.updateNeighborsAt(updatePos, (Block)this);
        }
        return state;
    }

    protected void notifyTrailNeighborsOfStateChange(Level world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() == this) {
            world.updateNeighborsAt(pos, (Block)this);
            for (Direction dir : Direction.values()) {
                world.updateNeighborsAt(pos.relative(dir), (Block)this);
            }
        }
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.getBlock() != state.getBlock() && !world.isClientSide) {
            this.updateSurroundingSaltPower(world, pos, state);
            for (Direction dir : Direction.Plane.VERTICAL) {
                world.updateNeighborsAt(pos.relative(dir), (Block)this);
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                this.notifyTrailNeighborsOfStateChange(world, pos.relative(dir));
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos offsetPos = pos.relative(dir);
                if (world.getBlockState(offsetPos).isRedstoneConductor((BlockGetter)world, offsetPos)) {
                    this.notifyTrailNeighborsOfStateChange(world, offsetPos.above());
                    continue;
                }
                this.notifyTrailNeighborsOfStateChange(world, offsetPos.below());
            }
        }
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.getBlock() != newState.getBlock()) {
            super.onRemove(state, world, pos, newState, isMoving);
            if (!world.isClientSide) {
                for (Direction dir : Direction.values()) {
                    world.updateNeighborsAt(pos.relative(dir), (Block)this);
                }
                this.updateSurroundingSaltPower(world, pos, state);
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    this.notifyTrailNeighborsOfStateChange(world, pos.relative(dir));
                }
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    BlockPos offsetPos = pos.relative(dir);
                    if (world.getBlockState(offsetPos).isRedstoneConductor((BlockGetter)world, offsetPos)) {
                        this.notifyTrailNeighborsOfStateChange(world, offsetPos.above());
                        continue;
                    }
                    this.notifyTrailNeighborsOfStateChange(world, offsetPos.below());
                }
            }
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.isClientSide) {
            if (state.canSurvive((LevelReader)world, pos)) {
                this.updateSurroundingSaltPower(world, pos, state);
            } else {
                SaltTrailBlock.dropResources((BlockState)state, (Level)world, (BlockPos)pos);
                world.removeBlock(pos, false);
            }
        }
    }

    @Override
    public int getStrongSaltPower(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return this.canProvidePower ? (Integer)blockState.getValue((Property)POWER) : 0;
    }

    protected boolean isPowerSourceAt(BlockGetter world, BlockPos pos, Direction side) {
        BlockPos offsetPos = pos.relative(side);
        BlockState offsetState = world.getBlockState(offsetPos);
        boolean isOffsetNormal = offsetState.isRedstoneConductor(world, offsetPos);
        BlockPos upPos = pos.above();
        boolean isUpNormal = world.getBlockState(upPos).isRedstoneConductor(world, upPos);
        if (!isUpNormal && isOffsetNormal && this.canConnectTo(world.getBlockState(offsetPos.above()), world, offsetPos.above(), null)) {
            return true;
        }
        if (this.canConnectTo(offsetState, world, offsetPos, side)) {
            return true;
        }
        return !isOffsetNormal && this.canConnectTo(world.getBlockState(offsetPos.below()), world, offsetPos.below(), null);
    }

    public static int colorMultiplier(int power) {
        float powerRatio = (float)power / 15.0f;
        float colorRatio = power == 0 ? 0.6f : powerRatio * 0.3f + 0.7f;
        int color = Mth.clamp((int)((int)(colorRatio * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | color << 16 | color << 8 | color;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int power = (Integer)state.getValue((Property)POWER);
        if (power > 0) {
            double x = (double)pos.getX() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double y = (float)pos.getY() + 0.0625f;
            double z = (double)pos.getZ() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float powerRatio = (float)power / 15.0f;
            float colorRatio = power == 0 ? 0.6f : powerRatio * 0.3f + 0.7f;
            world.addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(colorRatio, colorRatio, colorRatio), 1.0f), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((SaltSide)((Object)state.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((SaltSide)((Object)state.getValue(EAST)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((SaltSide)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SaltSide)((Object)state.getValue(NORTH)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((SaltSide)((Object)state.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((SaltSide)((Object)state.getValue(SOUTH)))));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SaltSide)((Object)state.getValue(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, (Comparable)((Object)((SaltSide)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SaltSide)((Object)state.getValue(EAST)))));
            }
        }
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, SOUTH, WEST, POWER});
    }
}

