/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.network.PacketHandler;
import com.verdantartifice.primalmagick.common.network.packets.misc.OpenEnchantedBookScreenPacket;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualLecternTileEntity;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import com.verdantartifice.primalmagick.platform.Services;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.awt.Color;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualLecternBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final MapCodec<RitualLecternBlock> CODEC = RitualLecternBlock.simpleCodec(RitualLecternBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    protected static final VoxelShape BASE_AND_STAND_SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0));
    protected static final VoxelShape COLLISION_SHAPE = Shapes.or((VoxelShape)BASE_AND_STAND_SHAPE, (VoxelShape)Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0));
    protected static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)0.0, (double)10.0, (double)1.0, (double)16.0, (double)14.0, (double)5.333333), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)5.333333, (double)16.0, (double)16.0, (double)9.666667), Block.box((double)0.0, (double)14.0, (double)9.666667, (double)16.0, (double)18.0, (double)14.0), BASE_AND_STAND_SHAPE});
    protected static final Map<Direction, VoxelShape> SHAPES = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, SHAPE);
        map.put(Direction.SOUTH, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
        map.put(Direction.WEST, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
        map.put(Direction.EAST, VoxelShapeUtils.rotate(SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
    });

    public RitualLecternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_BOOK, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return BASE_AND_STAND_SHAPE;
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return COLLISION_SHAPE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES.getOrDefault(state.getValue((Property)FACING), BASE_AND_STAND_SHAPE);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation direction) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)direction.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_BOOK});
    }

    protected ItemInteractionResult useItemOn(ItemStack handStack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!worldIn.isClientSide && handIn == InteractionHand.MAIN_HAND && (blockEntity = worldIn.getBlockEntity(pos)) instanceof RitualLecternTileEntity) {
            RitualLecternTileEntity lecternTile = (RitualLecternTileEntity)blockEntity;
            ItemStack bookStack = lecternTile.getItem();
            if (bookStack.isEmpty() && handStack.is(Items.ENCHANTED_BOOK)) {
                ItemStack stack = handStack.copyWithCount(1);
                lecternTile.setItem(stack);
                player.getItemInHand(handIn).shrink(1);
                if (player.getItemInHand(handIn).getCount() <= 0) {
                    player.setItemInHand(handIn, ItemStack.EMPTY);
                }
                player.getInventory().setChanged();
                worldIn.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.TRUE), 3);
                if (this.isPropOpen(state, worldIn, pos)) {
                    this.onPropActivated(state, worldIn, pos, this.getUsageStabilityBonus());
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!bookStack.isEmpty()) {
                if (player.isSecondaryUseActive()) {
                    ItemStack stack = bookStack.copy();
                    lecternTile.setItem(ItemStack.EMPTY);
                    if (!player.getInventory().add(stack)) {
                        player.drop(stack, false);
                    }
                    player.getInventory().setChanged();
                    worldIn.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.FALSE), 3);
                    return ItemInteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bookStack).entrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue)).findFirst().ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Holder<Enchantment>)((Holder)entry.getKey()), (HolderLookup.Provider)player.registryAccess()), serverPlayer));
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(handStack, state, worldIn, pos, player, handIn, hit);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        RitualLecternTileEntity lecternTile;
        ItemStack bookStack;
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof RitualLecternTileEntity && !(bookStack = (lecternTile = (RitualLecternTileEntity)blockEntity).getItem()).isEmpty()) {
            if (pPlayer.isSecondaryUseActive()) {
                ItemStack stack = bookStack.copy();
                lecternTile.setItem(ItemStack.EMPTY);
                if (!pPlayer.getInventory().add(stack)) {
                    pPlayer.drop(stack, false);
                }
                pPlayer.getInventory().setChanged();
                pLevel.playSound(null, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)HAS_BOOK, (Comparable)Boolean.FALSE), 3);
                return InteractionResult.SUCCESS;
            }
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)bookStack).entrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue)).findFirst().ifPresent(entry -> PacketHandler.sendToPlayer(new OpenEnchantedBookScreenPacket((Holder<Enchantment>)((Holder)entry.getKey()), (HolderLookup.Provider)pPlayer.registryAccess()), serverPlayer));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!worldIn.isClientSide && state.getBlock() != newState.getBlock()) {
            this.closeProp(state, worldIn, pos);
        }
        if (state.getBlock() != newState.getBlock() && (tile = worldIn.getBlockEntity(pos)) instanceof RitualLecternTileEntity) {
            RitualLecternTileEntity lecternTile = (RitualLecternTileEntity)tile;
            lecternTile.dropContents(worldIn, pos);
            worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.getX() + rand.nextDouble(), (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), Color.WHITE.getRGB());
        }
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        return state != null && state.hasProperty((Property)HAS_BOOK) && (Boolean)state.getValue((Property)HAS_BOOK) != false;
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.ritual_lectern";
    }

    public float getUsageStabilityBonus() {
        return 10.0f;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Services.BLOCK_ENTITY_PROTOTYPES.ritualLectern().create(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

