/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.rituals.IRitualPropBlock;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualBellTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.awt.Color;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RitualBellBlock
extends BaseEntityBlock
implements IRitualPropBlock {
    public static final MapCodec<RitualBellBlock> CODEC = RitualBellBlock.simpleCodec(RitualBellBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BellAttachType> ATTACHMENT = BlockStateProperties.BELL_ATTACHMENT;
    protected static final VoxelShape BELL_CORE_SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0), (VoxelShape)Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)6.0, (double)12.0));
    protected static final VoxelShape FLOOR_SHAPE = Shapes.or((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(ResourceUtils.loc("block/ritual_bell_floor")));
    protected static final VoxelShape CEILING_SHAPE = Shapes.or((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(ResourceUtils.loc("block/ritual_bell_ceiling")));
    protected static final VoxelShape ONE_WALL_SHAPE = Shapes.or((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(ResourceUtils.loc("block/ritual_bell_wall")));
    protected static final VoxelShape TWO_WALLS_SHAPE = Shapes.or((VoxelShape)BELL_CORE_SHAPE, (VoxelShape)VoxelShapeUtils.fromModel(ResourceUtils.loc("block/ritual_bell_between_walls")));
    protected static final Map<BellAttachType, Map<Direction, VoxelShape>> SHAPES = (Map)Util.make((Object)Maps.newEnumMap(BellAttachType.class), map -> {
        map.put(BellAttachType.FLOOR, (Map)Util.make((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, FLOOR_SHAPE);
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.EAST, VoxelShapeUtils.rotate(FLOOR_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
        }));
        map.put(BellAttachType.CEILING, (Map)Util.make((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, CEILING_SHAPE);
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.EAST, VoxelShapeUtils.rotate(CEILING_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
        }));
        map.put(BellAttachType.SINGLE_WALL, (Map)Util.make((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(ONE_WALL_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.EAST, ONE_WALL_SHAPE);
        }));
        map.put(BellAttachType.DOUBLE_WALL, (Map)Util.make((Object)Maps.newEnumMap(Direction.class), innerMap -> {
            innerMap.put(Direction.NORTH, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_90));
            innerMap.put(Direction.SOUTH, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90));
            innerMap.put(Direction.WEST, VoxelShapeUtils.rotate(TWO_WALLS_SHAPE, Direction.Axis.Y, Rotation.CLOCKWISE_180));
            innerMap.put(Direction.EAST, TWO_WALLS_SHAPE);
        }));
    });

    public RitualBellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(ATTACHMENT, (Comparable)BellAttachType.FLOOR));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ATTACHMENT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        BellAttachType attachment = (BellAttachType)state.getValue(ATTACHMENT);
        Direction facing = (Direction)state.getValue((Property)FACING);
        return SHAPES.getOrDefault(attachment, Collections.emptyMap()).getOrDefault(facing, BELL_CORE_SHAPE);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected static Direction getAttachmentDirection(BlockState state) {
        switch ((BellAttachType)state.getValue(ATTACHMENT)) {
            case FLOOR: {
                return Direction.DOWN;
            }
            case CEILING: {
                return Direction.UP;
            }
        }
        return (Direction)state.getValue((Property)FACING);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        Direction direction = RitualBellBlock.getAttachmentDirection(state);
        return direction == Direction.UP ? Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.above(), (Direction)Direction.DOWN) : FaceAttachedHorizontalDirectionalBlock.canAttach((LevelReader)worldIn, (BlockPos)pos, (Direction)direction);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getClickedFace();
        BlockPos blockpos = context.getClickedPos();
        Level world = context.getLevel();
        Direction.Axis axis = direction.getAxis();
        if (axis == Direction.Axis.Y) {
            BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachType.CEILING : BellAttachType.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection());
            if (blockstate.canSurvive((LevelReader)context.getLevel(), blockpos)) {
                return blockstate;
            }
        } else {
            boolean flag = axis == Direction.Axis.X && world.getBlockState(blockpos.west()).isFaceSturdy((BlockGetter)world, blockpos.west(), Direction.EAST) && world.getBlockState(blockpos.east()).isFaceSturdy((BlockGetter)world, blockpos.east(), Direction.WEST) || axis == Direction.Axis.Z && world.getBlockState(blockpos.north()).isFaceSturdy((BlockGetter)world, blockpos.north(), Direction.SOUTH) && world.getBlockState(blockpos.south()).isFaceSturdy((BlockGetter)world, blockpos.south(), Direction.NORTH);
            BlockState blockstate1 = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction.getOpposite())).setValue(ATTACHMENT, (Comparable)(flag ? BellAttachType.DOUBLE_WALL : BellAttachType.SINGLE_WALL));
            if (blockstate1.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockstate1;
            }
            boolean flag1 = world.getBlockState(blockpos.below()).isFaceSturdy((BlockGetter)world, blockpos.below(), Direction.UP);
            if ((blockstate1 = (BlockState)blockstate1.setValue(ATTACHMENT, (Comparable)(flag1 ? BellAttachType.FLOOR : BellAttachType.CEILING))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return blockstate1;
            }
        }
        return null;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        BellAttachType attachment = (BellAttachType)stateIn.getValue(ATTACHMENT);
        Direction direction = RitualBellBlock.getAttachmentDirection(stateIn);
        if (direction == facing && !stateIn.canSurvive((LevelReader)worldIn, currentPos) && attachment != BellAttachType.DOUBLE_WALL) {
            return Blocks.AIR.defaultBlockState();
        }
        if (facing.getAxis() == ((Direction)stateIn.getValue((Property)FACING)).getAxis()) {
            if (attachment == BellAttachType.DOUBLE_WALL && !facingState.isFaceSturdy((BlockGetter)worldIn, facingPos, facing)) {
                return (BlockState)((BlockState)stateIn.setValue(ATTACHMENT, (Comparable)BellAttachType.SINGLE_WALL)).setValue((Property)FACING, (Comparable)facing.getOpposite());
            }
            if (attachment == BellAttachType.SINGLE_WALL && direction.getOpposite() == facing && facingState.isFaceSturdy((BlockGetter)worldIn, facingPos, (Direction)stateIn.getValue((Property)FACING))) {
                return (BlockState)stateIn.setValue(ATTACHMENT, (Comparable)BellAttachType.DOUBLE_WALL);
            }
        }
        return super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RitualBellTileEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return RitualBellBlock.createTickerHelper(type, BlockEntityTypesPM.RITUAL_BELL.get(), RitualBellTileEntity::tick);
    }

    public void onProjectileHit(Level worldIn, BlockState state, BlockHitResult hit, Projectile projectile) {
        Entity entity = projectile.getOwner();
        Player playerentity = entity instanceof Player ? (Player)entity : null;
        this.tryRing(worldIn, state, hit, playerentity);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        return this.tryRing(worldIn, state, hit, player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    protected boolean tryRing(Level world, BlockState state, BlockHitResult hit, @Nullable Player player) {
        BlockPos pos;
        Direction dir = hit.getDirection();
        if (this.canRingFrom(state, dir, hit.getLocation().y - (double)(pos = hit.getBlockPos()).getY())) {
            this.doRing(state, world, pos, dir);
            return true;
        }
        return false;
    }

    protected void doRing(BlockState state, Level world, BlockPos pos, @Nullable Direction dir) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (!world.isClientSide && tile instanceof RitualBellTileEntity) {
            if (dir == null) {
                dir = (Direction)world.getBlockState(pos).getValue((Property)FACING);
            }
            ((RitualBellTileEntity)tile).ring(dir);
            world.playSound(null, pos, SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
            if (this.isPropOpen(state, world, pos)) {
                this.onPropActivated(state, world, pos, this.getUsageStabilityBonus());
            }
        }
    }

    protected boolean canRingFrom(BlockState state, Direction dir, double yPos) {
        if (dir.getAxis() != Direction.Axis.Y && yPos <= 0.8124) {
            Direction facing = (Direction)state.getValue((Property)FACING);
            BellAttachType attachment = (BellAttachType)state.getValue(ATTACHMENT);
            switch (attachment) {
                case FLOOR: {
                    return facing.getAxis() == dir.getAxis();
                }
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return facing.getAxis() != dir.getAxis();
                }
                case CEILING: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.isClientSide && state.getBlock() != newState.getBlock()) {
            this.closeProp(state, worldIn, pos);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.getX() + rand.nextDouble(), (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), Color.WHITE.getRGB());
        }
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.02f;
    }

    @Override
    public boolean isPropActivated(BlockState state, Level world, BlockPos pos) {
        RitualBellTileEntity bell;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity instanceof RitualBellTileEntity && (bell = (RitualBellTileEntity)blockEntity).isRinging();
    }

    @Override
    public String getPropTranslationKey() {
        return "ritual.primalmagick.prop.ritual_bell";
    }

    public float getUsageStabilityBonus() {
        return 10.0f;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

