/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.rituals.ISaltPowered;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.rituals.RitualAltarTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class RitualAltarBlock
extends BaseEntityBlock
implements ISaltPowered {
    public static final MapCodec<RitualAltarBlock> CODEC = RitualAltarBlock.simpleCodec(RitualAltarBlock::new);

    public RitualAltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        for (Direction dir : Direction.values()) {
            worldIn.updateNeighborsAt(pos.relative(dir), (Block)this);
        }
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!isMoving) {
            for (Direction dir : Direction.values()) {
                worldIn.updateNeighborsAt(pos.relative(dir), (Block)this);
            }
        }
        if (state.getBlock() != newState.getBlock() && (tile = worldIn.getBlockEntity(pos)) instanceof RitualAltarTileEntity) {
            RitualAltarTileEntity altarTile = (RitualAltarTileEntity)tile;
            altarTile.dropContents(worldIn, pos);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public int getMaxSaltPower() {
        return 15;
    }

    public int getMaxSafeSalt() {
        return 16;
    }

    @Override
    public int getStrongSaltPower(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return side != Direction.UP ? this.getMaxSaltPower() : 0;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Services.BLOCK_ENTITY_PROTOTYPES.ritualAltar().create(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return RitualAltarBlock.createTickerHelper(type, BlockEntityTypesPM.RITUAL_ALTAR.get(), Services.BLOCK_ENTITY_TICKERS.ritualAltar());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        RitualAltarTileEntity altarTile;
        BlockEntity tile;
        if (!worldIn.isClientSide && (tile = worldIn.getBlockEntity(pos)) instanceof RitualAltarTileEntity && !(altarTile = (RitualAltarTileEntity)tile).getItem().isEmpty()) {
            ItemStack stack = altarTile.getItem().copy();
            altarTile.setItem(ItemStack.EMPTY);
            if (!stack.isEmpty() && !player.getInventory().add(stack)) {
                player.drop(stack, false);
            }
            player.getInventory().setChanged();
            worldIn.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

