/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.rituals;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.rituals.IRitualStabilizer;
import com.verdantartifice.primalmagick.common.tiles.rituals.OfferingPedestalTileEntity;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OfferingPedestalBlock
extends BaseEntityBlock
implements IRitualStabilizer {
    public static final MapCodec<OfferingPedestalBlock> CODEC = OfferingPedestalBlock.simpleCodec(OfferingPedestalBlock::new);
    protected static final VoxelShape SHAPE = VoxelShapeUtils.fromModel(ResourceUtils.loc("block/offering_pedestal"));

    public OfferingPedestalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (this.isBlockSaltPowered((BlockGetter)worldIn, pos)) {
            FxDispatcher.INSTANCE.spellTrail((double)pos.getX() + rand.nextDouble(), (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), Color.WHITE.getRGB());
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return Services.BLOCK_ENTITY_PROTOTYPES.offeringPedestal().create(pos, state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        OfferingPedestalTileEntity pedestalTile;
        BlockEntity blockEntity;
        if (handIn == InteractionHand.MAIN_HAND && (blockEntity = worldIn.getBlockEntity(pos)) instanceof OfferingPedestalTileEntity && (pedestalTile = (OfferingPedestalTileEntity)blockEntity).getItem().isEmpty() && !stack.isEmpty()) {
            ItemStack placementStack = stack.copyWithCount(1);
            pedestalTile.setItem(placementStack);
            player.getItemInHand(handIn).shrink(1);
            if (player.getItemInHand(handIn).getCount() <= 0) {
                player.setItemInHand(handIn, ItemStack.EMPTY);
            }
            player.getInventory().setChanged();
            worldIn.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, worldIn, pos, player, handIn, hit);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        OfferingPedestalTileEntity pedestalTile;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof OfferingPedestalTileEntity && !(pedestalTile = (OfferingPedestalTileEntity)blockEntity).getItem().isEmpty()) {
            ItemStack stack = pedestalTile.getItem().copy();
            pedestalTile.setItem(ItemStack.EMPTY);
            if (!stack.isEmpty() && !pPlayer.getInventory().add(stack)) {
                pPlayer.drop(stack, false);
            }
            pPlayer.getInventory().setChanged();
            pLevel.playSound(null, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.4f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(pState, pLevel, pPos, pPlayer, pHitResult);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSymmetryPenalty(Level world, BlockPos pos, BlockPos otherPos) {
        BlockEntity tile = world.getBlockEntity(pos);
        BlockEntity otherTile = world.getBlockEntity(otherPos);
        if (tile instanceof OfferingPedestalTileEntity) {
            if (!(otherTile instanceof OfferingPedestalTileEntity)) return true;
        }
        if (!(tile instanceof OfferingPedestalTileEntity) && otherTile instanceof OfferingPedestalTileEntity) {
            return true;
        }
        if (world.isClientSide) {
            if (!(tile instanceof OfferingPedestalTileEntity)) return false;
            OfferingPedestalTileEntity pedestal = (OfferingPedestalTileEntity)tile;
            if (!(otherTile instanceof OfferingPedestalTileEntity)) return false;
            OfferingPedestalTileEntity otherPedestal = (OfferingPedestalTileEntity)otherTile;
            if (pedestal.getSyncedStack().isEmpty() == otherPedestal.getSyncedStack().isEmpty()) return false;
            return true;
        }
        if (!(tile instanceof OfferingPedestalTileEntity)) return false;
        OfferingPedestalTileEntity pedestal = (OfferingPedestalTileEntity)tile;
        if (!(otherTile instanceof OfferingPedestalTileEntity)) return false;
        OfferingPedestalTileEntity otherPedestal = (OfferingPedestalTileEntity)otherTile;
        if (pedestal.getItem().isEmpty() == otherPedestal.getItem().isEmpty()) return false;
        return true;
    }

    @Override
    public float getStabilityBonus(Level world, BlockPos pos) {
        return 0.0f;
    }

    @Override
    public float getSymmetryPenalty(Level world, BlockPos pos) {
        return 0.01f;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tile = worldIn.getBlockEntity(pos);
            if (tile instanceof OfferingPedestalTileEntity) {
                OfferingPedestalTileEntity pedestalTile = (OfferingPedestalTileEntity)tile;
                pedestalTile.dropContents(worldIn, pos);
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

