/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.google.common.collect.Maps;
import com.verdantartifice.primalmagick.common.blockstates.properties.SkyglassPaneSide;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkyglassPaneBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SkyglassPaneSide> NORTH = EnumProperty.create((String)"north", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> EAST = EnumProperty.create((String)"east", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> SOUTH = EnumProperty.create((String)"south", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> WEST = EnumProperty.create((String)"west", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> UP = EnumProperty.create((String)"up", SkyglassPaneSide.class);
    public static final EnumProperty<SkyglassPaneSide> DOWN = EnumProperty.create((String)"down", SkyglassPaneSide.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final Map<Direction, EnumProperty<SkyglassPaneSide>> FACING_TO_PROPERTY_MAP = (Map)Util.make((Object)Maps.newEnumMap(Direction.class), map -> {
        map.put(Direction.NORTH, NORTH);
        map.put(Direction.EAST, EAST);
        map.put(Direction.SOUTH, SOUTH);
        map.put(Direction.WEST, WEST);
        map.put(Direction.UP, UP);
        map.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] collisionShapes;
    protected final VoxelShape[] shapes;
    protected final Object2IntMap<BlockState> stateShapeIndices = new Object2IntOpenHashMap();

    public SkyglassPaneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
        this.collisionShapes = this.makeShapes(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(NORTH, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue(EAST, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue(SOUTH, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue(WEST, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue(UP, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue(DOWN, (Comparable)((Object)SkyglassPaneSide.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float extensionWidth, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - nodeWidth;
        float f1 = 8.0f + nodeWidth;
        float f2 = 8.0f - extensionWidth;
        float f3 = 8.0f + extensionWidth;
        VoxelShape voxelshape = Block.box((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.box((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.box((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.box((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.box((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = Shapes.or((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{Shapes.empty(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, Shapes.or((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), Shapes.or((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), Shapes.or((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < avoxelshape.length; ++i) {
            avoxelshape[i] = Shapes.or((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.collisionShapes[this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        ToIntFunction<BlockState> mappingFunction = s -> {
            int index = 0;
            if (s.getValue(NORTH) == SkyglassPaneSide.GLASS || s.getValue(NORTH) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.NORTH);
            }
            if (s.getValue(SOUTH) == SkyglassPaneSide.GLASS || s.getValue(SOUTH) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.SOUTH);
            }
            if (s.getValue(WEST) == SkyglassPaneSide.GLASS || s.getValue(WEST) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.WEST);
            }
            if (s.getValue(EAST) == SkyglassPaneSide.GLASS || s.getValue(EAST) == SkyglassPaneSide.OTHER) {
                index |= SkyglassPaneBlock.getDirectionMask(Direction.EAST);
            }
            return index;
        };
        return this.stateShapeIndices.computeIfAbsent((Object)state, mappingFunction);
    }

    protected static int getDirectionMask(Direction dir) {
        return 1 << dir.get2DDataValue();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getCurrentState(this.defaultBlockState(), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return this.getCurrentState(stateIn, worldIn, currentPos);
    }

    protected BlockState getCurrentState(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(UP, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.UP)))).setValue(DOWN, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.DOWN)))).setValue(NORTH, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.NORTH)))).setValue(SOUTH, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.SOUTH)))).setValue(WEST, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.WEST)))).setValue(EAST, (Comparable)((Object)this.getSideConnection(state, world, pos, Direction.EAST)))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(pos).getType() == Fluids.WATER));
    }

    protected SkyglassPaneSide getSideConnection(BlockState state, LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState adjacent = world.getBlockState(pos.relative(dir));
        if (adjacent == null || SkyglassPaneBlock.isExceptionForConnection((BlockState)adjacent)) {
            return SkyglassPaneSide.NONE;
        }
        if (state.getBlock() == adjacent.getBlock()) {
            return SkyglassPaneSide.GLASS;
        }
        if (adjacent.isFaceSturdy((BlockGetter)world, pos.relative(dir), dir.getOpposite()) || adjacent.getBlock() instanceof SkyglassPaneBlock) {
            return SkyglassPaneSide.OTHER;
        }
        return SkyglassPaneSide.NONE;
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (adjacentBlockState.getBlock() == state.getBlock()) {
            if (!side.getAxis().isHorizontal()) {
                return true;
            }
            if (state.getValue((Property)FACING_TO_PROPERTY_MAP.get(side)) == SkyglassPaneSide.GLASS && adjacentBlockState.getValue((Property)FACING_TO_PROPERTY_MAP.get(side.getOpposite())) == SkyglassPaneSide.GLASS) {
                return true;
            }
        }
        return super.skipRendering(state, adjacentBlockState, side);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(SOUTH)))))).setValue(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(WEST)))))).setValue(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(NORTH)))))).setValue(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(EAST)))));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(WEST)))))).setValue(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(NORTH)))))).setValue(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(EAST)))))).setValue(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(SOUTH)))));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(EAST)))))).setValue(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(NORTH)))));
            }
        }
        return state;
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.setValue(NORTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(SOUTH)))))).setValue(SOUTH, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(NORTH)))));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.setValue(EAST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(WEST)))))).setValue(WEST, (Comparable)((Object)((SkyglassPaneSide)((Object)state.getValue(EAST)))));
            }
        }
        return state;
    }
}

