/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SkyglassBlock
extends TransparentBlock {
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.create((String)"east");

    public SkyglassBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.FALSE)).setValue((Property)DOWN, (Comparable)Boolean.FALSE)).setValue((Property)NORTH, (Comparable)Boolean.FALSE)).setValue((Property)SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)WEST, (Comparable)Boolean.FALSE)).setValue((Property)EAST, (Comparable)Boolean.FALSE));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getCurrentState(this.defaultBlockState(), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(stateIn, worldIn, currentPos);
    }

    protected BlockState getCurrentState(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.UP)))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.DOWN)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.NORTH)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.WEST)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.isSideConnected(state, world, pos, Direction.EAST)));
    }

    protected boolean isSideConnected(BlockState state, LevelAccessor world, BlockPos pos, Direction dir) {
        BlockState adjacent = world.getBlockState(pos.relative(dir));
        return adjacent != null && state.getBlock() == adjacent.getBlock();
    }
}

