/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PillarBlock
extends Block {
    protected static final VoxelShape SHAPE_BASE = VoxelShapeUtils.fromModel(ResourceUtils.loc("block/pillar"));
    protected static final VoxelShape SHAPE_BOTTOM = VoxelShapeUtils.fromModel(ResourceUtils.loc("block/pillar_bottom"));
    protected static final VoxelShape SHAPE_TOP = VoxelShapeUtils.fromModel(ResourceUtils.loc("block/pillar_top"));
    public static final EnumProperty<Type> PROPERTY_TYPE = EnumProperty.create((String)"type", Type.class);

    public PillarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PROPERTY_TYPE, (Comparable)((Object)Type.BASE)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch (((Type)((Object)state.getValue(PROPERTY_TYPE))).ordinal()) {
            case 1: {
                return SHAPE_BOTTOM;
            }
            case 2: {
                return SHAPE_TOP;
            }
        }
        return SHAPE_BASE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PROPERTY_TYPE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getCurrentState((LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getCurrentState(worldIn, currentPos);
    }

    protected BlockState getCurrentState(LevelAccessor world, BlockPos pos) {
        boolean up = world.getBlockState(pos.above()).getBlock() instanceof PillarBlock;
        boolean down = world.getBlockState(pos.below()).getBlock() instanceof PillarBlock;
        if (up && down) {
            return (BlockState)this.defaultBlockState().setValue(PROPERTY_TYPE, (Comparable)((Object)Type.BASE));
        }
        if (up) {
            return (BlockState)this.defaultBlockState().setValue(PROPERTY_TYPE, (Comparable)((Object)Type.BOTTOM));
        }
        if (down) {
            return (BlockState)this.defaultBlockState().setValue(PROPERTY_TYPE, (Comparable)((Object)Type.TOP));
        }
        return (BlockState)this.defaultBlockState().setValue(PROPERTY_TYPE, (Comparable)((Object)Type.BASE));
    }

    public static enum Type implements StringRepresentable
    {
        BASE("base"),
        BOTTOM("bottom"),
        TOP("top");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

