/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.google.common.collect.ImmutableMap;
import com.verdantartifice.primalmagick.common.util.VoxelShapeUtils;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderwardBlock
extends Block {
    public static final int EFFECT_RADIUS = 16;
    protected static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape BASE_AABB = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final Map<Direction, VoxelShape> AABBS = new EnumMap<Direction, VoxelShape>((Map<Direction, VoxelShape>)ImmutableMap.builder().put((Object)Direction.NORTH, (Object)BASE_AABB).put((Object)Direction.SOUTH, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.CLOCKWISE_180)).put((Object)Direction.WEST, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.CLOCKWISE_90)).put((Object)Direction.EAST, (Object)VoxelShapeUtils.rotate(BASE_AABB, Direction.Axis.Y, Rotation.COUNTERCLOCKWISE_90)).build());

    public EnderwardBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instabreak().pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return AABBS.getOrDefault(pState.getValue((Property)FACING), BASE_AABB);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        BlockPos blockPos = pPos.relative(direction.getOpposite());
        BlockState blockState = pLevel.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)pLevel, blockPos, direction);
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction[] directions;
        BlockState blockState = this.defaultBlockState();
        Level levelReader = pContext.getLevel();
        BlockPos blockPos = pContext.getClickedPos();
        for (Direction dir : directions = pContext.getNearestLookingDirections()) {
            Direction oppositeDir;
            if (!dir.getAxis().isHorizontal() || !(blockState = (BlockState)blockState.setValue((Property)FACING, (Comparable)(oppositeDir = dir.getOpposite()))).canSurvive((LevelReader)levelReader, blockPos)) continue;
            return blockState;
        }
        return null;
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return pDirection.getOpposite() == pState.getValue((Property)FACING) && !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : pState;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        Direction stepDir = ((Direction)pState.getValue((Property)FACING)).getOpposite();
        for (int i = 0; i < 3; ++i) {
            int j = pRandom.nextInt(2) * 2 - 1;
            int k = pRandom.nextInt(2) * 2 - 1;
            int l = pRandom.nextInt(2) * 2 - 1;
            double d0 = (double)pPos.getX() + 0.5 + (double)stepDir.getStepX() * 0.4375 + 0.125 * (double)j;
            double d1 = (double)pPos.getY() + 0.5 + 0.125 * (double)k;
            double d2 = (double)pPos.getZ() + 0.5 + (double)stepDir.getStepZ() * 0.4375 + 0.125 * (double)l;
            double d3 = pRandom.nextFloat() * (float)j;
            double d4 = pRandom.nextFloat() * (float)k;
            double d5 = pRandom.nextFloat() * (float)l;
            pLevel.addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
        }
    }
}

