/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.misc;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.common.tiles.misc.CarvedBookshelfTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CarvedBookshelfBlock
extends BaseEntityBlock {
    public static final MapCodec<CarvedBookshelfBlock> CODEC = CarvedBookshelfBlock.simpleCodec(CarvedBookshelfBlock::new);
    public static final int MAX_BOOKS = 6;
    public static final int BOOKS_PER_ROW = 3;
    public static final List<BooleanProperty> SLOT_OCCUPIED_PROPERTIES = List.of(BlockStateProperties.CHISELED_BOOKSHELF_SLOT_0_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_1_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_2_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_3_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_4_OCCUPIED, BlockStateProperties.CHISELED_BOOKSHELF_SLOT_5_OCCUPIED);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public CarvedBookshelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState blockState = (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH);
        for (BooleanProperty prop : SLOT_OCCUPIED_PROPERTIES) {
            blockState = (BlockState)blockState.setValue((Property)prop, (Comparable)Boolean.FALSE);
        }
        this.registerDefaultState(blockState);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{FACING});
        SLOT_OCCUPIED_PROPERTIES.forEach(prop -> pBuilder.add(new Property[]{prop}));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CarvedBookshelfTileEntity) {
            CarvedBookshelfTileEntity tile = (CarvedBookshelfTileEntity)blockEntity;
            if (!pStack.is(ItemTags.BOOKSHELF_BOOKS)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            OptionalInt slotOpt = this.getHitSlot(pHitResult, pState);
            if (slotOpt.isEmpty()) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)pState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(slotOpt.getAsInt()))).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            CarvedBookshelfBlock.addBook(pLevel, pPos, pPlayer, tile, pStack, slotOpt.getAsInt());
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CarvedBookshelfTileEntity) {
            CarvedBookshelfTileEntity tile = (CarvedBookshelfTileEntity)blockEntity;
            OptionalInt slotOpt = this.getHitSlot(pHitResult, pState);
            if (slotOpt.isEmpty()) {
                return InteractionResult.PASS;
            }
            if (!((Boolean)pState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(slotOpt.getAsInt()))).booleanValue()) {
                return InteractionResult.CONSUME;
            }
            CarvedBookshelfBlock.removeBook(pLevel, pPos, pPlayer, tile, slotOpt.getAsInt());
            return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private OptionalInt getHitSlot(BlockHitResult pHitReselt, BlockState pState) {
        return CarvedBookshelfBlock.getRelativeHitCoordinatesForBlockFace(pHitReselt, (Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)).map(hitPos -> {
            int i = hitPos.y >= 0.5f ? 0 : 1;
            int j = CarvedBookshelfBlock.getSection(hitPos.x);
            return OptionalInt.of(j + i * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static void addBook(Level pLevel, BlockPos pPos, Player pPlayer, CarvedBookshelfTileEntity tile, ItemStack bookStack, int slot) {
        if (!pLevel.isClientSide) {
            pPlayer.awardStat(Stats.ITEM_USED.get((Object)bookStack.getItem()));
            SoundEvent soundEvent = bookStack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
            tile.addBook(slot, bookStack.split(1));
            pLevel.playSound(null, pPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static void removeBook(Level pLevel, BlockPos pPos, Player pPlayer, CarvedBookshelfTileEntity tile, int slot) {
        if (!pLevel.isClientSide) {
            ItemStack oldStack = tile.removeBook(slot);
            SoundEvent soundEvent = oldStack.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
            pLevel.playSound(null, pPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.getInventory().add(oldStack)) {
                pPlayer.drop(oldStack, false);
            }
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, pPos);
        }
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult hitResult, Direction face) {
        Direction hitDirection = hitResult.getDirection();
        if (face != hitDirection) {
            return Optional.empty();
        }
        BlockPos pos = hitResult.getBlockPos().relative(hitDirection);
        Vec3 relVec = hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        return switch (hitDirection) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - relVec.x()), (float)relVec.y()));
            case Direction.SOUTH -> Optional.of(new Vec2((float)relVec.x(), (float)relVec.y()));
            case Direction.WEST -> Optional.of(new Vec2((float)relVec.z(), (float)relVec.y()));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - relVec.z()), (float)relVec.y()));
            default -> Optional.empty();
        };
    }

    private static int getSection(float x) {
        if (x < 0.375f) {
            return 0;
        }
        if (x < 0.6875f) {
            return 1;
        }
        return 2;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.getBlock() != pNewState.getBlock()) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof CarvedBookshelfTileEntity) {
                CarvedBookshelfTileEntity tile = (CarvedBookshelfTileEntity)blockEntity;
                tile.dropContents(pLevel, pPos);
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return Services.BLOCK_ENTITY_PROTOTYPES.carvedBookshelf().create(pPos, pState);
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        if (pLevel.isClientSide) {
            return 0;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CarvedBookshelfTileEntity) {
            CarvedBookshelfTileEntity tile = (CarvedBookshelfTileEntity)blockEntity;
            return tile.getLastInteractedSlot() + 1;
        }
        return 0;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

