/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.minerals;

import com.verdantartifice.primalmagick.common.blocks.minerals.BuddingGemClusterBlock;
import com.verdantartifice.primalmagick.common.blocks.minerals.GemBudType;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class BuddingGemSourceBlock
extends Block {
    protected static final int GROWTH_CHANCE = 5;
    protected final GemBudType gemType;
    protected final Supplier<Block> initialBudSupplier;
    protected final Supplier<Block> decayBlockSupplier;
    protected final float decayChance;

    public BuddingGemSourceBlock(GemBudType gemType, Supplier<Block> initialBudSupplier, Supplier<Block> decayBlockSupplier, float decayChance, BlockBehaviour.Properties properties) {
        super(properties);
        this.gemType = gemType;
        this.initialBudSupplier = initialBudSupplier;
        this.decayBlockSupplier = decayBlockSupplier;
        this.decayChance = decayChance;
    }

    public void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0) {
            Direction dir = Direction.values()[pRandom.nextInt(Direction.values().length)];
            BlockPos targetPos = pPos.relative(dir);
            BlockState targetState = pLevel.getBlockState(targetPos);
            Block newBlock = null;
            if (targetState.isAir() || targetState.is(Blocks.WATER) && targetState.getFluidState().getAmount() == 8) {
                newBlock = this.initialBudSupplier.get();
            } else {
                BuddingGemClusterBlock cluster;
                Block block = targetState.getBlock();
                if (block instanceof BuddingGemClusterBlock && (cluster = (BuddingGemClusterBlock)block).getGemBudType() == this.gemType && targetState.getValue((Property)BuddingGemClusterBlock.FACING) == dir && cluster.getNextGemBlock().isPresent()) {
                    newBlock = cluster.getNextGemBlock().get().get();
                }
            }
            if (newBlock instanceof BuddingGemClusterBlock) {
                BuddingGemClusterBlock newCluster = (BuddingGemClusterBlock)newBlock;
                BlockState newClusterState = (BlockState)((BlockState)newCluster.defaultBlockState().setValue((Property)BuddingGemClusterBlock.FACING, (Comparable)dir)).setValue((Property)BuddingGemClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(targetState.getFluidState().getType() == Fluids.WATER));
                pLevel.setBlockAndUpdate(targetPos, newClusterState);
                if (pRandom.nextFloat() < this.decayChance) {
                    pLevel.setBlockAndUpdate(pPos, this.decayBlockSupplier.get().defaultBlockState());
                }
            }
        }
    }
}

