/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.mana;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.verdantartifice.primalmagick.common.misc.DeviceTier;
import com.verdantartifice.primalmagick.common.misc.ITieredDevice;
import com.verdantartifice.primalmagick.common.tiles.BlockEntityTypesPM;
import com.verdantartifice.primalmagick.common.tiles.base.IOwnedTileEntity;
import com.verdantartifice.primalmagick.common.tiles.mana.ManaBatteryTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class ManaBatteryBlock
extends BaseEntityBlock
implements ITieredDevice {
    public static final MapCodec<ManaBatteryBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DeviceTier.CODEC.fieldOf("tier").forGetter(b -> b.tier), (App)ManaBatteryBlock.propertiesCodec()).apply((Applicative)instance, ManaBatteryBlock::new));
    protected final DeviceTier tier;

    public ManaBatteryBlock(DeviceTier tier, BlockBehaviour.Properties properties) {
        super(properties);
        this.tier = tier;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return Services.BLOCK_ENTITY_PROTOTYPES.manaBattery().create(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return ManaBatteryBlock.createTickerHelper(pBlockEntityType, BlockEntityTypesPM.MANA_BATTERY.get(), Services.BLOCK_ENTITY_TICKERS.manaBattery());
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!pLevel.isClientSide && pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            BlockEntity tile = pLevel.getBlockEntity(pPos);
            if (tile instanceof ManaBatteryTileEntity) {
                ManaBatteryTileEntity batteryTile = (ManaBatteryTileEntity)tile;
                Services.PLAYER.openMenu(serverPlayer, batteryTile, tile.getBlockPos());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof ManaBatteryTileEntity) {
                ManaBatteryTileEntity batteryTile = (ManaBatteryTileEntity)blockEntity;
                batteryTile.getRouteTable().invalidate();
                batteryTile.dropContents(pLevel, pPos);
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    @Override
    public DeviceTier getDeviceTier() {
        return this.tier;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (!pLevel.isClientSide && pPlacer instanceof Player) {
            Player player = (Player)pPlacer;
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof IOwnedTileEntity) {
                IOwnedTileEntity ownedTile = (IOwnedTileEntity)blockEntity;
                ownedTile.setTileOwner(player);
            }
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

