/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.golems;

import com.verdantartifice.primalmagick.common.entities.companions.CompanionManager;
import com.verdantartifice.primalmagick.common.entities.golems.AbstractEnchantedGolemEntity;
import com.verdantartifice.primalmagick.common.research.requirements.AbstractRequirement;
import com.verdantartifice.primalmagick.common.wands.IInteractWithWand;
import com.verdantartifice.primalmagick.common.wands.IWand;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractEnchantedGolemControllerBlock<T extends AbstractEnchantedGolemEntity>
extends Block
implements IInteractWithWand {
    protected static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    @Nullable
    private BlockPattern golemPattern;

    public AbstractEnchantedGolemControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract AbstractRequirement<?> getRequirement();

    protected abstract EntityType<T> getEntityType();

    protected abstract Block getBaseBlock();

    protected abstract Block getControllerBlock();

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Override
    public InteractionResult onWandRightClick(ItemStack wandStack, Level world, Player player, BlockPos pos, Direction direction) {
        if (!world.isClientSide && wandStack.getItem() instanceof IWand && this.getRequirement().isMetBy(player)) {
            BlockPattern.BlockPatternMatch helper = this.getGolemPattern().find((LevelReader)world, pos);
            if (helper != null) {
                for (int i = 0; i < this.getGolemPattern().getWidth(); ++i) {
                    for (int j = 0; j < this.getGolemPattern().getHeight(); ++j) {
                        BlockInWorld info = helper.getBlock(i, j, 0);
                        world.setBlock(info.getPos(), Blocks.AIR.defaultBlockState(), 2);
                        world.levelEvent(2001, info.getPos(), Block.getId((BlockState)info.getState()));
                    }
                }
                BlockPos blockpos = helper.getBlock(1, 2, 0).getPos();
                AbstractEnchantedGolemEntity golem = (AbstractEnchantedGolemEntity)this.getEntityType().create(world);
                CompanionManager.addCompanion(player, golem);
                golem.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.05, (double)blockpos.getZ() + 0.5, 0.0f, 0.0f);
                world.addFreshEntity((Entity)golem);
                for (int i = 0; i < this.getGolemPattern().getWidth(); ++i) {
                    for (int j = 0; j < this.getGolemPattern().getHeight(); ++j) {
                        BlockInWorld info = helper.getBlock(i, j, 0);
                        world.blockUpdated(info.getPos(), Blocks.AIR);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public void onWandUseTick(ItemStack wandStack, Level level, Player player, Vec3 targetPos, int count) {
    }

    protected BlockPattern getGolemPattern() {
        if (this.golemPattern == null) {
            this.golemPattern = BlockPatternBuilder.start().aisle(new String[]{"~^~", "###", "~#~"}).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)this.getControllerBlock()))).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)this.getBaseBlock()))).where('~', b -> b.getState().isAir()).build();
        }
        return this.golemPattern;
    }
}

