/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.flowers;

import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EmberflowerBlock
extends TallFlowerBlock {
    public EmberflowerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean mayPlaceOn(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return super.mayPlaceOn(pState, pLevel, pPos) || pState.is(BlockTags.SOUL_FIRE_BASE_BLOCKS);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(5) == 0 && pState.getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.UPPER) {
            Vec3 offset = pState.getOffset((BlockGetter)pLevel, pPos);
            double x = (double)pPos.getX() + (0.3 + 0.4 * pRandom.nextDouble()) + offset.x();
            double y = (double)pPos.getY() + (0.3 + 0.4 * pRandom.nextDouble());
            double z = (double)pPos.getZ() + (0.3 + 0.4 * pRandom.nextDouble()) + offset.z();
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
            pLevel.addParticle((ParticleOptions)ParticleTypesPM.INFERNAL_FLAME.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

