/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.flowers;

import com.verdantartifice.primalmagick.client.fx.FxDispatcher;
import com.verdantartifice.primalmagick.common.damagesource.DamageSourcesPM;
import com.verdantartifice.primalmagick.common.tags.EntityTypeTagsPM;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BloodRoseBlock
extends TallFlowerBlock {
    public BloodRoseBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pRandom.nextInt(10) == 0) {
            Vec3 offset = pState.getOffset((BlockGetter)pLevel, pPos);
            double x = (double)pPos.getX() + (0.1 + 0.8 * pRandom.nextDouble()) + offset.x();
            double y = (double)pPos.getY() + (0.1 + 0.8 * pRandom.nextDouble());
            double z = (double)pPos.getZ() + (0.1 + 0.8 * pRandom.nextDouble()) + offset.z();
            FxDispatcher.INSTANCE.bloodDrop(x, y, z);
        }
    }

    public void entityInside(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity.getType() != EntityType.ITEM && !pEntity.getType().is(EntityTypeTagsPM.BLOOD_ROSE_IMMUNE)) {
            pEntity.hurt(DamageSourcesPM.bloodRose(pLevel.registryAccess()), 1.0f);
        }
    }
}

