/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.devices;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.common.blocks.devices.AbstractWindGeneratorBlock;
import com.verdantartifice.primalmagick.common.sources.Sources;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class VoidTurbineBlock
extends AbstractWindGeneratorBlock {
    public static final MapCodec<VoidTurbineBlock> CODEC = VoidTurbineBlock.simpleCodec(VoidTurbineBlock::new);

    public VoidTurbineBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Direction getWindDirection(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    @Override
    public int getCoreColor() {
        return Sources.VOID.getColor();
    }

    @Override
    public ParticleOptions getParticleType() {
        return (ParticleOptions)ParticleTypesPM.VOID_SMOKE.get();
    }

    @Override
    protected Vec3 getParticleStartPoint(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int lineOfSightPower;
        Vec3 startPoint = super.getParticleStartPoint(state, level, pos, random);
        int power = level.getBestNeighborSignal(pos);
        Direction facing = (Direction)state.getValue((Property)AbstractWindGeneratorBlock.FACING);
        if (power < 1) {
            return startPoint;
        }
        for (lineOfSightPower = 0; lineOfSightPower < power && level.isEmptyBlock(pos.relative(facing, lineOfSightPower + 1)); ++lineOfSightPower) {
        }
        return startPoint.add(new Vec3(facing.step()).scale((double)lineOfSightPower));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

