/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.devices;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.client.fx.particles.ParticleTypesPM;
import com.verdantartifice.primalmagick.common.blocks.misc.CarvedBookshelfBlock;
import com.verdantartifice.primalmagick.common.books.BookDefinition;
import com.verdantartifice.primalmagick.common.books.BookLanguage;
import com.verdantartifice.primalmagick.common.books.LinguisticsManager;
import com.verdantartifice.primalmagick.common.items.books.StaticBookItem;
import com.verdantartifice.primalmagick.common.tags.BlockTagsPM;
import com.verdantartifice.primalmagick.common.tiles.devices.ScribeTableTileEntity;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ScribeTableBlock
extends BaseEntityBlock {
    public static final MapCodec<ScribeTableBlock> CODEC = ScribeTableBlock.simpleCodec(ScribeTableBlock::new);
    protected static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final List<BlockPos> BOOKSHELF_OFFSETS = BlockPos.betweenClosedStream((int)-2, (int)0, (int)-2, (int)2, (int)1, (int)2).filter(pos -> Math.abs(pos.getX()) == 2 || Math.abs(pos.getZ()) == 2).map(BlockPos::immutable).toList();
    public static final int MAX_LINGUISTICS_POWER = 90;

    public ScribeTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (!worldIn.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity tile = worldIn.getBlockEntity(pos);
            if (tile instanceof ScribeTableTileEntity) {
                ScribeTableTileEntity tableTile = (ScribeTableTileEntity)tile;
                Services.PLAYER.openMenu(serverPlayer, tableTile, tile.getBlockPos());
            }
        }
        return InteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return Services.BLOCK_ENTITY_PROTOTYPES.scribeTable().create(pPos, pState);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        if (pState.getBlock() != pNewState.getBlock()) {
            BlockEntity tile = pLevel.getBlockEntity(pPos);
            if (tile instanceof ScribeTableTileEntity) {
                ScribeTableTileEntity castTile = (ScribeTableTileEntity)tile;
                castTile.dropContents(pLevel, pPos);
                pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
        }
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public static boolean isValidBookshelf(Level level, BlockPos tablePos, BlockPos bookshelfPosOffset) {
        BlockPos bookshelfPos = tablePos.offset((Vec3i)bookshelfPosOffset);
        return level.getBlockState(bookshelfPos).is(BlockTagsPM.LINGUISTICS_POWER_PROVIDERS) && level.getBlockState(tablePos.offset(bookshelfPosOffset.getX() / 2, bookshelfPosOffset.getY(), bookshelfPosOffset.getZ() / 2)).is(BlockTagsPM.LINGUISTICS_POWER_TRANSMITTERS) && ScribeTableBlock.hasBook(level, bookshelfPos);
    }

    public static boolean hasBook(Level level, BlockPos bookshelfPos) {
        BlockState state = level.getBlockState(bookshelfPos);
        return CarvedBookshelfBlock.SLOT_OCCUPIED_PROPERTIES.stream().anyMatch(prop -> state.hasProperty((Property)prop) && (Boolean)state.getValue((Property)prop) != false);
    }

    public static int getLinguisticsPower(Level level, BlockPos tablePos, Player player) {
        Set uniqueBookData = BOOKSHELF_OFFSETS.stream().filter(offset -> ScribeTableBlock.isValidBookshelf(level, tablePos, offset)).flatMap(offset -> ScribeTableBlock.getAncientBookAttributes(level, tablePos, offset).stream()).collect(Collectors.toSet());
        int totalPower = uniqueBookData.stream().mapToInt(pair -> LinguisticsManager.getTimesStudied(player, (Holder<BookDefinition>)((Holder)pair.getFirst()), (Holder<BookLanguage>)((Holder)pair.getSecond())) > 0 ? 1 : 0).sum();
        return Math.min(totalPower, 90);
    }

    private static Set<Pair<Holder<BookDefinition>, Holder<BookLanguage>>> getAncientBookAttributes(Level level, BlockPos tablePos, BlockPos bookshelfPosOffset) {
        HashSet<Pair<Holder<BookDefinition>, Holder<BookLanguage>>> retVal = new HashSet<Pair<Holder<BookDefinition>, Holder<BookLanguage>>>();
        Services.CAPABILITIES.itemHandler(level, tablePos.offset((Vec3i)bookshelfPosOffset), Direction.UP).ifPresent(handler -> {
            for (int index = 0; index < Math.min(handler.getSlots(), 6); ++index) {
                ItemStack bookStack = handler.getStackInSlot(index);
                StaticBookItem.getBookDefinition(bookStack).ifPresent(bookDefinition -> StaticBookItem.getBookLanguage(bookStack).ifPresent(bookLanguage -> {
                    if (((BookLanguage)bookLanguage.value()).isComplex()) {
                        retVal.add(Pair.of((Object)bookDefinition, (Object)bookLanguage));
                    }
                }));
            }
        });
        return retVal;
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        super.animateTick(pState, pLevel, pPos, pRandom);
        for (BlockPos offset : BOOKSHELF_OFFSETS) {
            if (pRandom.nextInt(16) != 0 || !ScribeTableBlock.isValidBookshelf(pLevel, pPos, offset)) continue;
            pLevel.addParticle((ParticleOptions)ParticleTypesPM.LINGUISTICS.get(), (double)pPos.getX() + 0.5, (double)pPos.getY() + 2.0, (double)pPos.getZ() + 0.5, (double)offset.getX() + pRandom.nextDouble() - 0.5, (double)offset.getY() - pRandom.nextDouble() - 1.0, (double)offset.getZ() + pRandom.nextDouble() - 0.5);
        }
    }
}

