/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.blocks.crops;

import com.mojang.serialization.MapCodec;
import com.verdantartifice.primalmagick.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class HydromelonBlock
extends Block {
    public static final MapCodec<HydromelonBlock> CODEC = HydromelonBlock.simpleCodec(HydromelonBlock::new);

    public HydromelonBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<HydromelonBlock> codec() {
        return CODEC;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer != null && Services.ITEM_ABILITIES.canAxeStrip(stack)) {
            boolean shouldVaporize = pLevel.dimensionType().ultraWarm();
            RandomSource rng = pPlayer.getRandom();
            pLevel.playSound(pPlayer, pPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (shouldVaporize) {
                pLevel.playSound(pPlayer, pPos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (pLevel.random.nextFloat() - pLevel.random.nextFloat()) * 0.8f);
                for (int index = 0; index < 8; ++index) {
                    pLevel.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)pPos.getX() + rng.nextDouble(), (double)pPos.getY() + rng.nextDouble(), (double)pPos.getZ() + rng.nextDouble(), 0.0, 0.0, 0.0);
                }
            }
            if (!pLevel.isClientSide) {
                if (shouldVaporize) {
                    pLevel.removeBlock(pPos, false);
                } else {
                    pLevel.setBlock(pPos, Blocks.WATER.defaultBlockState(), 11);
                }
                stack.hurtAndBreak(1, (LivingEntity)pPlayer, LivingEntity.getSlotForHand((InteractionHand)pHand));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

