/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.attunements;

import com.verdantartifice.primalmagick.common.advancements.critereon.CriteriaTriggersPM;
import com.verdantartifice.primalmagick.common.attunements.AttunementAttributeModifier;
import com.verdantartifice.primalmagick.common.attunements.AttunementThreshold;
import com.verdantartifice.primalmagick.common.attunements.AttunementType;
import com.verdantartifice.primalmagick.common.sources.Source;
import com.verdantartifice.primalmagick.common.sources.SourceList;
import com.verdantartifice.primalmagick.common.sources.Sources;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public class AttunementManager {
    protected static final List<AttunementAttributeModifier> MODIFIERS = new ArrayList<AttunementAttributeModifier>();
    private static final Set<UUID> SYNC_SET = ConcurrentHashMap.newKeySet();

    public static boolean isSyncScheduled(@Nullable Player player) {
        if (player == null) {
            return false;
        }
        return SYNC_SET.remove(player.getUUID());
    }

    public static void scheduleSync(@Nullable Player player) {
        if (player != null) {
            SYNC_SET.add(player.getUUID());
        }
    }

    public static void registerAttributeModifier(@Nonnull Source source, AttunementThreshold threshold, @Nonnull Holder<Attribute> attribute, @Nonnull ResourceLocation id, double modValue, @Nonnull AttributeModifier.Operation modOperation) {
        MODIFIERS.add(new AttunementAttributeModifier(source, threshold, attribute, id, modValue, modOperation));
    }

    public static int getAttunement(@Nullable Player player, @Nullable Source source, @Nullable AttunementType type) {
        if (player != null && source != null && type != null) {
            return Services.CAPABILITIES.attunements(player).map(a -> a.getValue(source, type)).orElse(0);
        }
        return 0;
    }

    public static int getTotalAttunement(@Nullable Player player, @Nullable Source source) {
        if (player != null && source != null) {
            return Services.CAPABILITIES.attunements(player).map(attunements -> {
                int total = 0;
                for (AttunementType type : AttunementType.values()) {
                    total += attunements.getValue(source, type);
                }
                return total;
            }).orElse(0);
        }
        return 0;
    }

    public static boolean meetsThreshold(@Nullable Player player, @Nullable Source source, @Nullable AttunementThreshold threshold) {
        if (player == null || source == null || threshold == null) {
            return false;
        }
        if (AttunementManager.isSuppressed(player, source)) {
            return false;
        }
        return AttunementManager.getTotalAttunement(player, source) >= threshold.getValue();
    }

    public static boolean isSuppressed(@Nullable Player player, @Nullable Source source) {
        if (player == null || source == null) {
            return false;
        }
        return Services.CAPABILITIES.attunements(player).map(attunements -> attunements.isSuppressed(source)).orElse(false);
    }

    public static void setSuppressed(@Nullable Player player, @Nullable Source source, boolean value) {
        if (player instanceof ServerPlayer && source != null) {
            Services.CAPABILITIES.attunements(player).ifPresent(attunements -> {
                boolean before = attunements.isSuppressed(source);
                Component sourceText = source.getNameText();
                attunements.setSuppressed(source, value);
                AttunementManager.scheduleSync(player);
                int total = AttunementManager.getTotalAttunement(player, source);
                if (!before && value) {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement.suppression_gain", (Object[])new Object[]{sourceText}), false);
                    Stream.of(AttunementThreshold.values()).filter(threshold -> total >= threshold.getValue()).forEach(threshold -> MODIFIERS.stream().filter(mod -> source.equals(mod.getSource()) && threshold == mod.getThreshold()).forEach(mod -> mod.removeFromEntity((LivingEntity)player)));
                } else if (before && !value) {
                    player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement.suppression_loss", (Object[])new Object[]{sourceText}), false);
                    Stream.of(AttunementThreshold.values()).filter(threshold -> total >= threshold.getValue()).forEach(threshold -> MODIFIERS.stream().filter(mod -> source.equals(mod.getSource()) && threshold == mod.getThreshold()).forEach(mod -> mod.applyToEntity((LivingEntity)player)));
                }
            });
        }
    }

    public static void setAttunement(@Nullable Player player, @Nullable Source source, @Nullable AttunementType type, int value) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (source != null && type != null) {
                Services.CAPABILITIES.attunements((Player)serverPlayer).ifPresent(attunements -> {
                    int oldTotal = AttunementManager.getTotalAttunement(player, source);
                    attunements.setValue(source, type, value);
                    AttunementManager.scheduleSync(player);
                    int newTotal = AttunementManager.getTotalAttunement(player, source);
                    for (AttunementThreshold threshold : AttunementThreshold.values()) {
                        int thresholdValue = threshold.getValue();
                        Component sourceText = source.getNameText();
                        Component thresholdText = threshold.getThresholdText();
                        if (oldTotal < thresholdValue && newTotal >= thresholdValue && !AttunementManager.isSuppressed(player, source)) {
                            if (source.isDiscovered(player)) {
                                player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement.threshold_gain", (Object[])new Object[]{sourceText, thresholdText}), false);
                            }
                            for (AttunementAttributeModifier modifier : MODIFIERS) {
                                if (!source.equals(modifier.getSource()) || threshold != modifier.getThreshold()) continue;
                                modifier.applyToEntity((LivingEntity)player);
                            }
                        }
                        if (oldTotal < thresholdValue || newTotal >= thresholdValue) continue;
                        if (source.isDiscovered(player) && !AttunementManager.isSuppressed(player, source)) {
                            player.displayClientMessage((Component)Component.translatable((String)"event.primalmagick.attunement.threshold_loss", (Object[])new Object[]{sourceText, thresholdText}), false);
                        }
                        for (AttunementAttributeModifier modifier : MODIFIERS) {
                            if (!source.equals(modifier.getSource()) || threshold != modifier.getThreshold()) continue;
                            modifier.removeFromEntity((LivingEntity)player);
                        }
                    }
                    int permanent = AttunementManager.getAttunement(player, source, AttunementType.PERMANENT);
                    int induced = AttunementManager.getAttunement(player, source, AttunementType.INDUCED);
                    int temporary = AttunementManager.getAttunement(player, source, AttunementType.TEMPORARY);
                    CriteriaTriggersPM.ATTUNEMENT_THRESHOLD.get().trigger(serverPlayer, source, permanent, induced, temporary);
                });
            }
        }
    }

    public static void setAttunement(@Nullable Player player, @Nullable AttunementType type, @Nullable SourceList values) {
        if (values != null && !values.isEmpty()) {
            for (Source source : values.getSources()) {
                AttunementManager.setAttunement(player, source, type, values.getAmount(source));
            }
        }
    }

    public static void incrementAttunement(@Nullable Player player, @Nullable Source source, @Nullable AttunementType type, int delta) {
        int oldValue = AttunementManager.getAttunement(player, source, type);
        AttunementManager.setAttunement(player, source, type, oldValue + delta);
    }

    public static void incrementAttunement(@Nullable Player player, @Nullable Source source, @Nullable AttunementType type) {
        AttunementManager.incrementAttunement(player, source, type, 1);
    }

    public static void incrementAttunement(@Nullable Player player, @Nullable AttunementType type, @Nullable SourceList deltas) {
        SourceList.Builder newValues = SourceList.builder();
        for (Source source : deltas.getSources()) {
            int oldValue = AttunementManager.getAttunement(player, source, type);
            newValues.with(source, oldValue + deltas.getAmount(source));
        }
        AttunementManager.setAttunement(player, type, newValues.build());
    }

    public static void decayTemporaryAttunements(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            for (Source source : Sources.getAllSorted()) {
                AttunementManager.incrementAttunement(player, source, AttunementType.TEMPORARY, -1);
            }
        }
    }

    public static void removeAllAttributeModifiers(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            MODIFIERS.stream().forEach(modifier -> modifier.removeFromEntity((LivingEntity)player));
        }
    }

    public static void refreshAttributeModifiers(@Nullable Player player) {
        if (player instanceof ServerPlayer) {
            MODIFIERS.stream().filter(mod -> AttunementManager.meetsThreshold(player, mod.getSource(), mod.getThreshold())).forEach(mod -> mod.applyToEntity((LivingEntity)player));
        }
    }
}

