/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.primalmagick.common.armortrim;

import com.verdantartifice.primalmagick.common.items.ItemsPM;
import com.verdantartifice.primalmagick.common.util.ResourceUtils;
import com.verdantartifice.primalmagick.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.armortrim.TrimPattern;

public class TrimPatternsPM {
    public static final ResourceKey<TrimPattern> RUNIC = TrimPatternsPM.registryKey("runic");
    protected static final ChatFormatting TITLE_FORMAT = ChatFormatting.GRAY;
    protected static final ChatFormatting DESCRIPTION_FORMAT = ChatFormatting.BLUE;
    protected static final Component RUNIC_ARMOR_TRIM_APPLIES_TO = Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)ResourceUtils.loc("smithing_template.runic_armor_trim.applies_to"))).withStyle(DESCRIPTION_FORMAT);
    protected static final Component RUNIC_ARMOR_TRIM_INGREDIENTS = Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)ResourceUtils.loc("smithing_template.runic_armor_trim.ingredients"))).withStyle(DESCRIPTION_FORMAT);
    protected static final Component RUNIC_ARMOR_TRIM_BASE_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)ResourceUtils.loc("smithing_template.runic_armor_trim.base_slot_description")));
    protected static final Component RUNIC_ARMOR_TRIM_ADDITIONS_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"tooltip", (ResourceLocation)ResourceUtils.loc("smithing_template.runic_armor_trim.additions_slot_description")));
    protected static final List<ResourceLocation> RUNIC_TRIMMABLE_ARMOR_ICONS = List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots"));
    protected static final List<ResourceLocation> RUNIC_TRIMMABLE_MATERIAL_ICONS = List.of(ResourceUtils.loc("item/empty_rune_slot"));

    public static SmithingTemplateItem createRunicArmorTrimTemplate(ResourceKey<TrimPattern> patternKey) {
        return new SmithingTemplateItem(RUNIC_ARMOR_TRIM_APPLIES_TO, RUNIC_ARMOR_TRIM_INGREDIENTS, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)patternKey.location())).withStyle(TITLE_FORMAT), RUNIC_ARMOR_TRIM_BASE_SLOT_DESCRIPTION, RUNIC_ARMOR_TRIM_ADDITIONS_SLOT_DESCRIPTION, RUNIC_TRIMMABLE_ARMOR_ICONS, RUNIC_TRIMMABLE_MATERIAL_ICONS, new FeatureFlag[0]);
    }

    private static ResourceKey<TrimPattern> registryKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_PATTERN, (ResourceLocation)ResourceUtils.loc(name));
    }

    private static void register(BootstrapContext<TrimPattern> context, Item templateItem, ResourceKey<TrimPattern> patternKey) {
        context.register(patternKey, (Object)new TrimPattern(patternKey.location(), Services.ITEMS_REGISTRY.getHolder(templateItem).orElseThrow(), (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_pattern", (ResourceLocation)patternKey.location())), false));
    }

    public static void bootstrap(BootstrapContext<TrimPattern> context) {
        TrimPatternsPM.register(context, (Item)ItemsPM.RUNIC_ARMOR_TRIM_SMITHING_TEMPLATE.get(), RUNIC);
    }
}

